% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuantiles.R
\name{cuantiles}
\alias{cuantiles}
\title{Cuantiles.}
\usage{
cuantiles(x,
                 variable = NULL,
                 pesos = NULL,
                 cortes = c(0.25,0.5,0.75),
                 exportar = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere una sola variable, \code{variable = NULL}. En caso contrario, es necesario indicar el nombre o posición (número de columna) de la variable.}

\item{pesos}{Si los datos de la variable están resumidos en una distribución de frecuencias, debe indicarse la columna que representa los valores de la variable y la columna con las frecuencias o pesos.}

\item{cortes}{Vector con los puntos de corte a calcular. Por defecto se calcula el primer, segundo y tercer cuartil.}

\item{exportar}{Para exportar los resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}
}
\value{
Si \code{pesos = NULL}, la función devuelve los cuantiles de todas las variables seleccionadas en un objeto de tipo \code{data.frame}. En caso contrario, devuelve los cuantiles de la variable para la que se ha facilitado la distribución de frecuencias.
}
\description{
Calcula los cuantiles.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrcuantiles.png}{options: width="25\%" alt="Figure: qricvarianza.png"}}
\if{latex}{\figure{qrcuantiles.png}{options: width=3cm}}
}
\details{
Los cuantiles se obtienen a partir de la siguiente regla de decisión:

\if{html}{\figure{cuantiles.png}{options: width="85\%" alt="Figure: cuantiles.png"}}
\if{latex}{\figure{cuantiles.png}{options: scale=.85}}

Ni son las frecuencias acumuladas y n el tamaño de la muestra (o N si es la población).

cuartiles: s=1,2,3 y k=4

deciles: s= 1,2,...,9 y k=10

percentiles: s=1,2,...,99 y k=100
}
\examples{

cuantiles1 <- cuantiles(startup[1])
cuantiles2 <- cuantiles(startup,variable=1,cortes=seq(0.1,0.9,0.1))
cuantiles3 <- cuantiles(salarios2018,variable=6,pesos=7 )

}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\seealso{
\code{\link{media}}, \code{\link{mediana}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú} (\email{rosario.martinez@uv.es}).
\emph{Economía Aplicada.}

\strong{Cristina Pardo-García} (\email{cristina.pardo-garcia@uv.es}).
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}
}
