% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{get_color}
\alias{get_color}
\title{Get predefined colors}
\usage{
get_color(name, fill = FALSE, fill_color = "#DDDDDD", fill_n = 10)
}
\arguments{
\item{name}{Name of color/color-vector}

\item{fill}{Fill color vector?}

\item{fill_color}{Color to use to fill color vector}

\item{fill_n}{Number of color codes to return}
}
\value{
Vector of color-codes
}
\description{
Get predefined colors
}
\examples{
get_color("mario")

get_color("mario")
show_color(get_color("mario"))
show_color(get_color("mario", fill = TRUE, fill_n = 10))

col <- get_color("mario")
explore(iris, Sepal.Length, target = Species,
  color = col)
explore(iris, Sepal.Length, target = Species,
  color = c(col["peach"], col["bowser"], col["donkeykong"]))
}
