% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-functions.R
\name{ljung_box_test,fEGarch_fit-method}
\alias{ljung_box_test,fEGarch_fit-method}
\title{Weighted Ljung-Box Test for Autocorrelation}
\usage{
\S4method{ljung_box_test}{fEGarch_fit}(
  object,
  m_max = 20,
  weight_f = function(lag) {
     m <- max(lag)
     (m + 1 - lag)/m
 },
  adj_df = NULL,
  silent = FALSE,
  type = c("simple", "squared"),
  ...
)
}
\arguments{
\item{object}{an object \code{"fEGarch_fit"} as returned
by the fitting functions of this package, for example
by \code{\link{fEGarch}}.}

\item{m_max}{the maximum lag; tests will be conducted for 1 up to
\code{m_max}.}

\item{weight_f}{a function with argument \code{lag} stating how
weights should be calculated.}

\item{adj_df}{degrees of freedom to adjust for as a number or the default
\code{NULL}, which uses automatic values from the fitted object; for
squared residuals \code{adj_df = 0} is the default and for simple
returns, it is the sum of ARMA-parameters.}

\item{silent}{a logical value reflecting whether or not test results
should be printed in a well-formatted manner to the console.}

\item{type}{either \code{"simple"} or \code{"squared"} for applying
the test to simple or squared residuals.}

\item{...}{currently without use.}
}
\value{
Returns a numeric matrix invisibly.
}
\description{
Apply a (weighted) Ljung-Box test (through the
Gamma approximation) to check
the standardized residuals of a fitted model
from this package for remaining autocorrelation.
Two different options allow to check either the
simple residuals or the squared residuals.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
spec <- fEGarch_spec()
model <- fEGarch(spec, rt)
ljung_box_test(model)

}
