# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title DateParametersSummary
#' @description DateParametersSummary Class
#' @format An \code{R6Class} generator object
#' @field startdate  character [optional]
#'
#' @field enddate  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
DateParametersSummary <- R6::R6Class(
  'DateParametersSummary',
  public = list(
    `startdate` = NULL,
    `enddate` = NULL,
    initialize = function(`startdate`=NULL, `enddate`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`startdate`)) {
        stopifnot(is.character(`startdate`), length(`startdate`) == 1)
        self$`startdate` <- `startdate`
      }
      if (!is.null(`enddate`)) {
        stopifnot(is.character(`enddate`), length(`enddate`) == 1)
        self$`enddate` <- `enddate`
      }
    },
    toJSON = function() {
      DateParametersSummaryObject <- list()
      if (!is.null(self$`startdate`)) {
        DateParametersSummaryObject[['startdate']] <-
          self$`startdate`
      }
      if (!is.null(self$`enddate`)) {
        DateParametersSummaryObject[['enddate']] <-
          self$`enddate`
      }

      DateParametersSummaryObject
    },
    fromJSON = function(DateParametersSummaryJson) {
      DateParametersSummaryObject <- jsonlite::fromJSON(DateParametersSummaryJson)
      if (!is.null(DateParametersSummaryObject$`startdate`)) {
        self$`startdate` <- DateParametersSummaryObject$`startdate`
      }
      if (!is.null(DateParametersSummaryObject$`enddate`)) {
        self$`enddate` <- DateParametersSummaryObject$`enddate`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`startdate`)) {
        sprintf(
        '"startdate":
          "%s"
                ',
        self$`startdate`
        )},
        if (!is.null(self$`enddate`)) {
        sprintf(
        '"enddate":
          "%s"
                ',
        self$`enddate`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(DateParametersSummaryJson) {
      DateParametersSummaryObject <- jsonlite::fromJSON(DateParametersSummaryJson)
      self$`startdate` <- DateParametersSummaryObject$`startdate`
      self$`enddate` <- DateParametersSummaryObject$`enddate`
      self
    }
  )
)
