% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{cointegration_phillips_ouliaris}
\alias{cointegration_phillips_ouliaris}
\title{Phillips and Ouliaris Cointegration Test}
\usage{
cointegration_phillips_ouliaris(x, ...)
}
\arguments{
\item{x}{Matrix of data to be tested.}

\item{...}{Additional arguments passed to \code{\link[urca:ca.po]{urca::ca.po()}}.}
}
\value{
An object of class \code{ca.po}.
}
\description{
Performs the Phillips and Ouliaris \code{"Pu"} and \code{"Pz"}
  cointegration test.
}
\details{
The test \code{"Pz"}, compared to the test \code{"Pu"}, has the
  advantage that it is invariant to the normalization of the
  cointegration vector, \emph{i.e.} it does not matter which variable
  is on the left hand side of the equation. In case convergence
  problems are encountered by matrix inversion, one can pass a higher
  tolerance level \emph{via} \code{"tol=..."} to the \code{solve()}-function.
}
\examples{

cointegration_phillips_ouliaris(cbind(mdeaths, fdeaths))

}
\references{
Phillips, P.C.B. and Ouliaris, S. (1990), Asymptotic Properties of
  Residual Based Tests for Cointegration, \emph{Econometrica},
  \bold{Vol. 58, No. 1}, 165--193.
}
\seealso{
\code{\link[urca:ca.po]{urca::ca.po()}}
}
\author{
Bernhard Pfaff
}
