% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{graphic.params}
\alias{graphic.params}
\title{Standard graphics names}
\usage{
graphic.params(
  add.fignum,
  addBars,
  addTime,
  at.risk.palette,
  background.palette,
  bar.position,
  bar.width,
  base_family,
  base_size,
  bottom.axis.version,
  bottom.margin,
  category,
  category.color,
  category.col,
  category.label,
  category.symbol.col,
  category.palette,
  cd,
  censor.col,
  centime.col,
  dd,
  envir,
  fignum,
  fignum.buffer,
  filename,
  flip.palette,
  fnote,
  fnote.buffer,
  foot.size,
  fromthetop,
  gg.list,
  head.size,
  header.buffer,
  interior,
  interior.h,
  interior.w,
  killMissing,
  left.margin,
  linetype.col,
  line.size,
  linetype.palette,
  loadplan,
  logd,
  log.trans,
  lower.lim,
  main.theme,
  my.path,
  ncol,
  nrow,
  nsubj.plot.label,
  od,
  outfile,
  override,
  page.height,
  page.width,
  parent.df,
  pdval,
  Point.Est,
  pos,
  reportNR,
  response.col,
  right.margin,
  shape.label,
  shape.palette,
  source.code,
  text.buffer,
  test.dim,
  text.col,
  text.col1,
  text.col2,
  text.col3,
  text.col4,
  text.size,
  title,
  title.buffer,
  title.size,
  toBMP,
  toEPS,
  toJPEG,
  top.axis.version,
  top.margin,
  toPDF,
  toPNG,
  toWMF,
  ulh,
  upper.lim,
  urh,
  UseSubset,
  x.col,
  x.label,
  x.limits,
  x.ticks,
  x.ticks.labels,
  y.col,
  y.digits,
  y.label,
  y.label.col,
  y.label.rank.col,
  y.limits,
  y.rank.col,
  y.ticks,
  ymax.col,
  ymin.col
)
}
\arguments{
\item{add.fignum}{logical (annotate.page)}

\item{addBars}{logical to add error bars (line.plot)}

\item{addTime}{logical for ading time stamp (annotate.page)}

\item{at.risk.palette}{colors to be assocated with categorical variable in accompanying km.plot generated at.risk table}

\item{background.palette}{palette gets passed to scale_fill_manual (forest.plot)}

\item{bar.position}{passed to geom_bar (bar.plot)}

\item{bar.width}{used by line.plot}

\item{base_family}{used in set_theme calls}

\item{base_size}{used in set_theme calls}

\item{bottom.axis.version}{ggplot object with bottom x-axis (get.top.xaxis)}

\item{bottom.margin}{used by build.page and annotate.page}

\item{category}{option to add a column populated with a factor (by gcurve)}

\item{category.color}{data.frame column assocated with aes color mapping (forest.plot, line.plot, nsubj.plot, table.plot)}

\item{category.col}{data.frame column associated with categorical variable (bar.plot, box.plot, cdf.plot, dot.plot, km.plot)}

\item{category.label}{passed to x-axis label}

\item{category.symbol.col}{used by line.plot}

\item{category.palette}{colors assoicated with categorical variable}

\item{cd}{directory where driver (code) files are stored}

\item{censor.col}{name of parent.df column associated with censor variable}

\item{centime.col}{name of parent.df column associated with censored time}

\item{dd}{directory where data is stored}

\item{envir}{used internally by some functions}

\item{fignum}{figure number (annotate.page)}

\item{fignum.buffer}{fine-control of vertical position (annotate.page)}

\item{filename}{common_root.pdf or common_root.csv}

\item{flip.palette}{logical; if TRUE it reverse the order of colors used for background (forest.plot)}

\item{fnote}{vector of 5 footnotes. 5th row is traditionally reserved for filepath, table reference and time stamp. Populate from bottom up. (annotate.page)}

\item{fnote.buffer}{fine-control of vertical position (annotate.page)}

\item{foot.size}{default: 10; passed to grid.text via gp (annotate.page)}

\item{fromthetop}{logical. If TRUE KM curve decends from 1, if FALSE KM curve ascends from 0 Ensure you have an appropriate censor.col passed above!}

\item{gg.list}{a list of ggplot objects (sync.ylab.widths)}

\item{head.size}{default: 10 (anotate.page)}

\item{header.buffer}{fine-control of vertical position (anotate.page)}

\item{interior}{a list of nrow*ncol grobs/ggplot objects to be displayed in the grid, ordered by row then col (build.page)}

\item{interior.h}{a vector summing to 1 to indicate how to partition the heights (build.page)}

\item{interior.w}{a vector summing to 1 to indicate how to partition the widths (build.page)}

\item{killMissing}{logical used by bar.plot}

\item{left.margin}{used by build.page and annotate.page; presumed to be inches}

\item{linetype.col}{name of parent.df column associated with linetype}

\item{line.size}{value gets passed to size within geom_line, geom_step}

\item{linetype.palette}{values passed to scale_linetype_manual}

\item{loadplan}{logical; if TRUE then it loads from the filename}

\item{logd}{directory where log files are sent}

\item{log.trans}{Logical; if TRUE log transformation is applied to x axis (ensure x.limits are positive!) (forest.plot)}

\item{lower.lim}{column holding lower limit of CI}

\item{main.theme}{text string name of theme to be called by theme_set,}

\item{my.path}{path to main directory,}

\item{ncol}{number of columns for the grid of graphics being built by build.page}

\item{nrow}{number of rows for the grid of graphics being built by build.page}

\item{nsubj.plot.label}{used in km.plot}

\item{od}{directory where output files are sent}

\item{outfile}{If (toPDF== TRUE & outfile == "") a .pdf file with root name taken from outputplan$outfile[which(outputplan$rcode ==source.code)]. Otherwise a .pdf will be created the value of outfile. The pdf is stored in mypath/od defined in setpaths.r.}

\item{override}{override}

\item{page.height}{used by build.page and annotate.page; presumed to be inches}

\item{page.width}{used by build.page and annotate.page; presumed to be inches}

\item{parent.df}{data.frame used by ggplot}

\item{pdval}{value passed to position_dodge (lineplot)}

\item{Point.Est}{point estimate}

\item{pos}{used internally by some functions}

\item{reportNR}{If TRUE, a plot with missing figure numbers and titles is produced}

\item{response.col}{used by cdf.plottttt}

\item{right.margin}{used by build.page and annotate.page; presumed to be inches}

\item{shape.label}{value sets passed to labs}

\item{shape.palette}{values passed to scale_shape_manual}

\item{source.code}{This is intended to be a darapladib graphics driver file returning a graphic possibly with complete headers and footers.}

\item{text.buffer}{used by bar.plot to control text placement}

\item{test.dim}{logical. Assists with figure development. If TRUE it makes a call to grid.show.layout.}

\item{text.col}{used by nsubj.plot}

\item{text.col1}{name of column holding text for column 1 (table.plot)}

\item{text.col2}{name of column holding text for column 2; can be NULL (table.plot)}

\item{text.col3}{name of column holding text for column 3; can be NULL (table.plot)}

\item{text.col4}{name of column holding text for column 4; can be NULL (table.plot)}

\item{text.size}{value gets passed to geom_text}

\item{title}{vector of title lines (annotate.page)}

\item{title.buffer}{fine-control of vertical position (annotate.page)}

\item{title.size}{default: 14; passed to grid.text via gp (annotate.page)}

\item{toBMP}{Logical. If TRUE a .bmp file will be created. (run.specific)}

\item{toEPS}{Logical. If TRUE a .eps file will be created. (run.specific)}

\item{toJPEG}{Logical. If TRUE a .jpeg file will be created. (run.specific)}

\item{top.axis.version}{ggplot object with intended top x-axis in bottom position (get.top.xaxis)}

\item{top.margin}{used by build.page and annotate.page; presumed to be inches}

\item{toPDF}{Logical. If TRUE a .pdf file will be created. If FALSE graphic is sent to screen. (run.specific)}

\item{toPNG}{Logical. If TRUE a .png file will be created. (run.specific)}

\item{toWMF}{Logical. If TRUE a .wmf file will be created. (run.specific)}

\item{ulh}{vector for upper left headers (annotate.page)}

\item{upper.lim}{column holding upper limit of CI (forest.plot)}

\item{urh}{vector for upper right headers (annotate.page)}

\item{UseSubset}{Corresponds to a column name in outputplan holding flags (all_in_one)}

\item{x.col}{parent.df column associated with response vairable (line.plot, nsubj.plot)}

\item{x.label}{value gets passed to labs}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{x.ticks}{value gets passed to scale_x_continuous}

\item{x.ticks.labels}{passed to scale_x_continuous}

\item{y.col}{parent.df column associated with response vairable}

\item{y.digits}{passed to scale_y_continuous label's, fmt (box.plot, line.plot)}

\item{y.label}{value gets passed to labs}

\item{y.label.col}{column holding labels for forest/dot/table plots}

\item{y.label.rank.col}{column holding ranks for labels in forest/dot/table plots}

\item{y.limits}{passed to scale_y_continuous}

\item{y.rank.col}{column holding ranks for line items in forest/dot/table plots}

\item{y.ticks}{passed to scale_y_continuous}

\item{ymax.col}{name of parent.df column associated with ymax (line.plot errorbars)}

\item{ymin.col}{name of parent.df column associated with ymin (line.plot errorbars)}
}
\value{
This function is just a convenient location to store argument names.
}
\description{
This is a dummy function whose purpose is to serve as repository for arguments used by figuRes2 functions.
}
\author{
Greg Cicconetti
}
