% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_merge.R
\name{ff_merge}
\alias{ff_merge}
\alias{finalfit_merge}
\title{Merge a \code{\link{summary_factorlist}()} table with any number of model
results tables.}
\usage{
ff_merge(factorlist, fit2df_df, ref_symbol = "-", estimate_name = NULL,
  last_merge = FALSE)

finalfit_merge(factorlist, fit2df_df, ref_symbol = "-",
  estimate_name = NULL, last_merge = FALSE)
}
\arguments{
\item{factorlist}{Output from \code{\link{summary_factorlist}(...,
fit_id=TRUE)}.}

\item{fit2df_df}{Output from model wrappers followed by
\code{\link{fit2df}()}.}

\item{ref_symbol}{Reference symbol for model reference levels, typically "-"
or "1.0".}

\item{estimate_name}{If you have chosen a new `estimate name` (e.g. "Odds
ratio") when running a model wrapper (e.g. `glmuni`), then you need to pass
this new name to `finalfit_merge` to generate correct table. Defaults to
OR/HR/Coefficient}

\item{last_merge}{Logical. Set to try for the final merge in a series to
remove index and fit_id columns.}
}
\value{
Returns a dataframe of combined tables.
}
\description{
A function that takes the output from \code{\link{summary_factorlist}(...,
fit_id=TRUE)} and merges with any number of model dataframes, usually
produced with a model wrapper followed by the \code{\link{fit2df}()} function
(see examples).
}
\examples{
library(finalfit)
library(dplyr)

data(colon_s)
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
explanatory_multi = c("age.factor", "obstruct.factor")
random_effect = "hospital"
dependent = "mort_5yr"

# Create separate tables
colon_s \%>\%
 summary_factorlist(dependent, explanatory, fit_id=TRUE) -> example.summary

colon_s \%>\%
 glmuni(dependent, explanatory) \%>\%
 fit2df(estimate_suffix=" (univariable)") -> example.univariable

colon_s \%>\%
 glmmulti(dependent, explanatory) \%>\%
 fit2df(estimate_suffix=" (multivariable)") -> example.multivariable

colon_s \%>\%
 glmmixed(dependent, explanatory, random_effect) \%>\%
 fit2df(estimate_suffix=" (multilevel)") -> example.multilevel

# Pipe together
example.summary \%>\%
 ff_merge(example.univariable) \%>\%
 ff_merge(example.multivariable) \%>\%
 ff_merge(example.multilevel, last_merge = TRUE)

# Using finalfit()
colon_s \%>\%
 finalfit(dependent, explanatory, keep_fit_id = TRUE) \%>\%
 ff_merge(example.multilevel, last_merge = TRUE)
}
\seealso{
\code{\link{summary_factorlist}} \code{\link{fit2df}}
}
