% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmulti.R
\name{lmmulti}
\alias{lmmulti}
\title{Linear regression multivariable models: \code{finalfit} model wrapper}
\usage{
lmmulti(.data, dependent, explanatory, ...)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector of length 1: name of depdendent variable
(must a continuous vector).}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{...}{Other arguments to pass to \code{\link[stats]{lm}}.}
}
\value{
A multivariable \code{\link[stats]{lm}} fitted model.
}
\description{
Using \code{finalfit} conventions, produces a multivariable linear regression
model for a set of explanatory variables against a continuous dependent.
}
\details{
Uses \code{\link[stats]{lm}} with \code{finalfit} modelling conventions.
Output can be passed to \code{\link{fit2df}}.
}
\examples{
library(finalfit)
library(dplyr)

explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "nodes"

colon_s \%>\%
  lmmulti(dependent, explanatory) \%>\%
  fit2df()

}
\seealso{
\code{\link{fit2df}}

Other finalfit model wrappers: \code{\link{coxphmulti}},
  \code{\link{coxphuni}}, \code{\link{crrmulti}},
  \code{\link{crruni}}, \code{\link{glmmixed}},
  \code{\link{glmmulti_boot}}, \code{\link{glmmulti}},
  \code{\link{glmuni}}, \code{\link{lmmixed}},
  \code{\link{lmuni}}, \code{\link{svyglmmulti}},
  \code{\link{svyglmuni}}
}
\concept{finalfit model wrappers}
