% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{indicators}
\alias{indicators}
\title{Live indicators and the profiles and domains they belong to}
\usage{
indicators(ProfileID = NULL, DomainID = NULL, path)
}
\arguments{
\item{ProfileID}{Numeric vector, id of profiles of interest}

\item{DomainID}{Numeric vector, id of domains of interest}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A data frame of indicators within a profile or domain.
}
\description{
Outputs a data frame of indicators within a profile or domain
}
\examples{
\dontrun{
# Returns a complete data frame of indicators and their domains and profiles
indicators()

# Returns a data frame of all of the indicators in the Public Health Outcomes Framework
indicators(ProfileID = 19)}
}
\seealso{
\code{\link{area_types}} for area type  and their parent mappings,
  \code{\link{indicator_metadata}} for indicator metadata,
  \code{\link{profiles}} for profile lookups,
  \code{\link{deprivation_decile}} for deprivation decile lookups,
  \code{\link{category_types}} for category lookups,
  \code{\link{indicator_areatypes}} for indicators by area types lookups,
  \code{\link{indicators_unique}} for unique indicatorids and their names,
  \code{\link{nearest_neighbours}} for a vector of nearest neighbours for an area and
  \code{\link{indicator_order}} for the order indicators are presented on the
  Fingertips website within a Domain

Other lookup functions: \code{\link{area_types}},
  \code{\link{category_types}},
  \code{\link{deprivation_decile}},
  \code{\link{indicator_areatypes}},
  \code{\link{indicator_metadata}},
  \code{\link{indicator_order}},
  \code{\link{indicators_unique}},
  \code{\link{nearest_neighbours}}, \code{\link{profiles}}
}
\concept{lookup functions}
