% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{model.matrix.fixest}
\alias{model.matrix.fixest}
\title{Design matrix of a \code{femlm} model}
\usage{
\method{model.matrix}{fixest}(object, data, na.rm = TRUE, ...)
}
\arguments{
\item{object}{A \code{fixest} object. Obtained using the functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}.}

\item{data}{If missing (default) then the original data is obtained by evaluating the \code{call}. Otherwise, it should be a \code{data.frame}.}

\item{na.rm}{Default is \code{TRUE}. Should observations with NAs be removed from the matrix?}

\item{...}{Not currently used.}
}
\value{
It returns a design matrix.
}
\description{
This function creates a design matrix of the linear part of a \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}} estimation. Note that it is only the linear part. The fixed-effects variables (which can be considered as factors) are excluded from the matrix.
}
\examples{

# simple estimation on iris data, using "Species" fixed-effects
res = femlm(Sepal.Length ~ Sepal.Width*Petal.Length +
            Petal.Width | Species, iris)

head(model.matrix(res))



}
\seealso{
See also the main estimation functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. \code{\link[fixest]{formula.fixest}}, \code{\link[fixest]{update.fixest}}, \code{\link[fixest]{summary.fixest}}, \code{\link[fixest]{vcov.fixest}}.
}
\author{
Laurent Berge
}
