% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_print.R
\name{print.modeler}
\alias{print.modeler}
\title{Print an object of class \code{modeler}}
\usage{
\method{print}{modeler}(x, ...)
}
\arguments{
\item{x}{An object fitted with the function \code{modeler()}.}

\item{...}{Options used by the tibble package to format the output. See
`tibble::print()` for more details.}
}
\value{
an object inheriting from class \code{modeler}.
}
\description{
Prints information about \code{modeler} function.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(1:5)
  )
plot(mod_1, id = c(1:4))
print(mod_1)
}
\author{
Johan Aparicio [aut]
}
