% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{set_third_dimension}
\alias{set_third_dimension}
\title{Set third dimension of a flexible polyline encoded string}
\usage{
set_third_dimension(
  encoded,
  third_dim_name,
  precision = 5L,
  third_dim_precision = 5L
)
}
\arguments{
\item{encoded}{character, encoded flexible polyline string.}

\item{third_dim_name}{character, name of the third dimension to set (ABSENT,
LEVEL, ALTITUDE, ELEVATION, CUSTOM1, CUSTOM2).}

\item{precision}{integer, precision to use in encoding (between 0 and 15,
\code{default=5}).}

\item{third_dim_precision}{integer, precision to use in encoding for the
third dimension (between 1 and 15, \code{default=5}).}
}
\value{
The line with the new third dimension as string in the flexible polyline
encoding format.
}
\description{
This function decodes the flexible polyline encoded line, changes the third
dimension and encodes the line again.
}
\note{
The precision is not read from the header of the encoded line. Therefore it
must be provided as a parameter for re-encoding.
}
\examples{
# 2d line (nothing happens...)
set_third_dimension("BFoz5xJ67i1B1B7PzIhaxL7Y", "ELEVATION")

# 3d line
set_third_dimension("BlBoz5xJ67i1BU1B7PUzIhaUxL7YU", "ELEVATION")
}
