/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.contrasts;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.af.commons.widgets.lists.SplitListChangeListener;
import org.af.gMCP.gui.contrasts.AnalysisDialogListenerFactory;
import org.af.gMCP.gui.contrasts.LevelOrderSL;
import org.af.gMCP.gui.contrasts.VarSelectBox;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RLegalName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelOrderListener
implements ActionListener,
SplitListChangeListener<String> {
    private RDataFrame df;
    private VarSelectBox cbFactor;
    private LevelOrderSL slLevelOrder;
    private static List<String> lastLevelOrder = new ArrayList<String>();

    public LevelOrderListener(RDataFrame df, VarSelectBox cbFactor, LevelOrderSL slLevelOrder) {
        this.df = df;
        this.cbFactor = cbFactor;
        this.slLevelOrder = slLevelOrder;
        RLegalName g = (RLegalName)cbFactor.getSelectedObject();
        List<String> levels = Arrays.asList(df.getCol(g.toString()).asRFactor().getLevels());
        Collections.sort(levels);
        slLevelOrder.setLeft(levels);
        if (levels.containsAll(lastLevelOrder)) {
            slLevelOrder.setRight(lastLevelOrder);
            levels.removeAll(lastLevelOrder);
            slLevelOrder.setLeft(levels);
        }
        this.cbFactor.addActionListener(this);
        this.slLevelOrder.addSplitListChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AnalysisDialogListenerFactory.updateLevelOrderList(this.df, this.cbFactor, this.slLevelOrder);
    }

    private void saveLastLevelOrder() {
        lastLevelOrder.clear();
        lastLevelOrder.addAll(this.slLevelOrder.getRight());
    }

    public void modelStateChanged(List left, List right) {
        this.saveLastLevelOrder();
    }
}

