% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garma_ggtsdisplay.R
\name{garma_ggtsdisplay}
\alias{garma_ggtsdisplay}
\title{ggtsdisplay of underlying ARMA process.}
\usage{
garma_ggtsdisplay(x, k = 1, ...)
}
\arguments{
\item{x}{(num) This should be a numeric vector representing the process to estimate.}

\item{k}{(int) The number of Gegenbauer factors}

\item{...}{additional parameters to pass to ggtsdisplay}
}
\value{
A ggplot object.
}
\description{
For a Gegenbauer process, use semi-parametric methods to obtain short memory version of the process, then run a ggtsdisplay().
}
\details{
The purpose of this function is to ease the process of identifying the underlying short memory process.
}
\examples{
data(AirPassengers)
ap <- as.numeric(diff(AirPassengers,12))
garma_ggtsdisplay(ap)
}
