% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setter_funcs.R
\name{set_extrapolation_years_nearest}
\alias{set_extrapolation_years_nearest}
\title{Set the number of years to fill out using nearest available data}
\usage{
set_extrapolation_years_nearest(session, years)
}
\arguments{
\item{session}{A valid GDL session object to interface with.}

\item{years}{Number of years to copy (integer)}
}
\value{
An amended GDL session object.
}
\description{
Sets the number of years to fill out using nearest available data
at dataset edges, as a means of extrapolation. Turns extrapolation on
if it isn't already. Overrides the number of years to linearly
extrapolate if set.
}
\examples{
\dontrun{
# Create a session using your API token (provided by environment here)
session <- gdl_session(Sys.getenv('GDL_API_TOKEN'))
session <- set_extrapolation_years_nearest(session, 3)
}
}
