% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lesh.R
\name{plot.lesh_result}
\alias{plot.lesh_result}
\title{plot LESH model result}
\usage{
\method{plot}{lesh_result}(
  x,
  pie = TRUE,
  scatter = FALSE,
  scatter_alpha = 1,
  pieradius_factor = 15,
  pielegend_x = 0.99,
  pielegend_y = 0.1,
  pielegend_num = 3,
  ...
)
}
\arguments{
\item{x}{x Return by \code{lesh()}.}

\item{pie}{(optional) Whether to draw the interaction contributions. Default is \code{TRUE}.}

\item{scatter}{(optional) Whether to draw the interaction direction diagram. Default is \code{FALSE}.}

\item{scatter_alpha}{(optional) Picture transparency. Default is \code{1}.}

\item{pieradius_factor}{(optional) The radius expansion factor of interaction contributions pie plot. Default is \code{15}.}

\item{pielegend_x}{(optional) The X-axis relative position of interaction contributions pie plot legend. Default is \code{0.99}.}

\item{pielegend_y}{(optional) The Y-axis relative position of interaction contributions pie plot legend. Default is \code{0.1}.}

\item{pielegend_num}{(optional) The number of interaction contributions pie plot legend. Default is \code{3}.}

\item{...}{(optional) Other arguments passed to \code{ggplot2::theme()}.}
}
\value{
A ggplot2 layer.
}
\description{
S3 method to plot output for LESH model interaction result in \code{lesh()}.
}
\note{
When both \code{scatter} and \code{pie} are set to \code{TRUE} in RStudio, enlarge the drawing frame
for normal display.
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
