% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs_geodetecor.R
\name{srs_factor_detector}
\alias{srs_factor_detector}
\title{spatial rough set-based factor detector}
\usage{
srs_factor_detector(y, x, wt)
}
\arguments{
\item{y}{Variable Y, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{x}{Covariate X, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{wt}{Spatial adjacency matrix.}
}
\value{
A list.
\describe{
\item{\code{PD}}{the average local explanatory power}
\item{\code{SE_PD}}{the degree of spatial heterogeneity of the local explanatory power}
}
}
\description{
spatial rough set-based factor detector
}
\examples{
data('srs_table')
data('srs_wt')
srs_factor_detector(srs_table$d,srs_table$a1,srs_wt)

}
\references{
Bai, H., Li, D., Ge, Y., Wang, J., & Cao, F. (2022). Spatial rough set-based
geographical detectors for nominal target variables. Information Sciences, 586, 525–539.
https://doi.org/10.1016/j.ins.2021.12.019
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
