% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolm.R
\name{geolm}
\alias{geolm}
\title{Linear model for geostatistical data.}
\usage{
geolm(formula, data, coordnames, cmod = NULL, vmod = NULL,
  weights = NULL, longlat = FALSE, mu = NULL)
}
\arguments{
\item{formula}{An object of class formula.  See Details.}

\item{data}{A data frame containing the response, covariates, and location coordinates.}

\item{coordnames}{A vector of length 2 with the names of the columns in \code{data} containing the coordinates, e.g., \code{c("long", "lat")}.}

\item{cmod}{A covariance model object obtained from one of the \code{cmod.*} functions, e.g., \code{\link[gear]{cmod.std}}.}

\item{vmod}{A semivariance model object obtained from one of the \code{vmod.*} functions.  Not currently implemented.}

\item{weights}{An optional vector of weights for the errors to be used in the fitting process.  A vector that is proportional to the reciprocal variances of the errors, i.e., errors are assumed to be uncorrelated with variances \code{evar/weights}.  Default is \code{NULL}, meaning that the weights are uniformly 1.}

\item{longlat}{A logical value.  Default is \code{FALSE}.  If \code{TRUE}, Great Circle distances (WGS84 ellipsoid) are calcualted between locations.  Otherwise, Euclidean.}

\item{mu}{A single numeric value indicating the consant mean of the spatial process if simple kriging is desired.  Default is \code{NULL}, meaning that ordinary or universal kriging should be used.}
}
\value{
Returns a \code{geolm} object.
}
\description{
\code{geolm} creates a geostatistical linear model object of the appropriate class based on the arguments, especially the \code{cmod} arguments.
}
\details{
\code{formula} should be specified after the form \code{y ~ x1 + x2}, where \code{y} is the response variable and \code{x1} and \code{x2} are the covariates of interest.  If \code{mu} is provided, the variables to the right of \code{~} are ignored.
}
\examples{
data = data.frame(y = rnorm(10), x1 = runif(10), 
                 x2 = runif(10))
cmod = cmod.std(model = "exponential", psill = 1, 
                 r = 1)
gearmod = geolm(y ~ x1, data = data,
                 coordnames = c("x1", "x2"),
                 cmod = cmod)
}
\author{
Joshua French
}
