% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gems.r
\docType{class}
\name{PosteriorProbabilities}
\alias{PosteriorProbabilities}
\alias{PosteriorProbabilities-class}
\alias{[,PosteriorProbabilities,ANY,ANY,ANY-method}
\alias{[,PosteriorProbabilities-method}
\alias{[.PosteriorProbabilities}
\alias{head,PosteriorProbabilities-method}
\alias{head.PosteriorProbabilities}
\alias{plot,PosteriorProbabilities-method}
\alias{plot.PosteriorProbabilities}
\alias{tail,PosteriorProbabilities-method}
\alias{tail.PosteriorProbabilities}
\title{Class \code{"PosteriorProbabilities"}}
\usage{
\S4method{[}{PosteriorProbabilities,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{plot}{PosteriorProbabilities}(x, ci = FALSE, main = paste(x@type,
  "after starting in State", x@states[1], "at time 0"),
  states = 1:dim(x@probabilities)[2], lwd = c(2, 2), col = c("blue",
  "green3"), lty = c(1, 2), xlab = "Time", ylab = "Probability", ...)

\S4method{head}{PosteriorProbabilities}(x, ...)

\S4method{tail}{PosteriorProbabilities}(x, ...)
}
\arguments{
\item{x}{the PosteriorProbabilities object}

\item{i,j,drop}{same as for a \code{"data.frame"}}

\item{...}{arguments passed on to main method}

\item{ci}{should confidence intervals be displayed}

\item{main,xlab,ylab}{same as any plot}

\item{states}{which states to display}

\item{lwd,col,lty}{vectors of lentht 2, with first component for the
point estimate and second component for the confidence interval}
}
\description{
This S4 class summarizes the posterior probabilities over time for objects
of class \code{"ArtCohort"}
}
\section{Slots}{

\describe{
\item{\code{states}}{Object of class \code{"character"}: names of states}

\item{\code{times}}{Object of class \code{"numeric"}: time points at which probabilities are evaluated}

\item{\code{probabilities}}{Object of class \code{"matrix"}: posterior Probabilities to be in each state at each time}

\item{\code{lower}}{Object of class \code{"matrix"}: lower prediction bound to be in each state at each time}

\item{\code{upper}}{Object of class \code{"matrix"}: upper prediction bound to be in each state at each time}

\item{\code{type}}{Object of class \code{"character"}: describes type of probability}
}}
\section{Objects from the Class}{
 Objects are created by calls to the
function \code{simulateCohort}.
}
\examples{
showClass("PosteriorProbabilities")
}
\author{
Luisa Salazar Vizcaya, Nello Blaser, Thomas Gsponer
}
\seealso{
\code{\link{transitionProbabilities}},
\code{\link{cumulativeIncidence}}, \code{\link{ArtCohort}}
}
\keyword{classes}

