% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen3sis_species.R
\name{get_divergence_matrix}
\alias{get_divergence_matrix}
\title{Returns the full divergence matrix for a given species (site x site).}
\usage{
get_divergence_matrix(species)
}
\arguments{
\item{species}{the species for which the divergence matrix should be produced}
}
\value{
the full decompressed divergence matrix
}
\description{
Returns the full divergence matrix for a given species (site x site).
}
\details{
The functions allows to extract the full divergence matrix representing the accumulated differentiation
between all the sites that are occupied by the species. The input is a species object for any time step.
}
\examples{
# get path containing example rasters
datapath <- system.file(file.path("extdata", "WorldCenter"), package="gen3sis")
# get species at t0
species_t_0 <- readRDS(file.path(datapath, "output/config_worldcenter/species/species_t_0.rds"))
# get divergence matrix from species 1
divergence_sp1_t0 <- get_divergence_matrix(species_t_0[[1]])
# get divergence matrix from species 12
divergence_sp12_t0 <- get_divergence_matrix(species_t_0[[12]])
# note that species 1 has no divergence between it's populations, while 12 has.
}
