% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSStyleManager.R
\docType{class}
\name{GSStyleManager}
\alias{GSStyleManager}
\title{Geoserver REST API Style Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for managing the styles
of a GeoServer instance.
}
\description{
Geoserver REST API Style Manager

Geoserver REST API Style Manager
}
\examples{
\dontrun{
   GSStyleManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{style}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSStyleManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSStyleManager-getStyles}{\code{GSStyleManager$getStyles()}}
\item \href{#method-GSStyleManager-getStyleNames}{\code{GSStyleManager$getStyleNames()}}
\item \href{#method-GSStyleManager-getStyle}{\code{GSStyleManager$getStyle()}}
\item \href{#method-GSStyleManager-createStyle}{\code{GSStyleManager$createStyle()}}
\item \href{#method-GSStyleManager-updateStyle}{\code{GSStyleManager$updateStyle()}}
\item \href{#method-GSStyleManager-deleteStyle}{\code{GSStyleManager$deleteStyle()}}
\item \href{#method-GSStyleManager-getSLDVersion}{\code{GSStyleManager$getSLDVersion()}}
\item \href{#method-GSStyleManager-getSLDBody}{\code{GSStyleManager$getSLDBody()}}
\item \href{#method-GSStyleManager-clone}{\code{GSStyleManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR"><a href='../../geosapi/html/GSManager.html#method-GSManager-ERROR'><code>geosapi::GSManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO"><a href='../../geosapi/html/GSManager.html#method-GSManager-INFO'><code>geosapi::GSManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN"><a href='../../geosapi/html/GSManager.html#method-GSManager-WARN'><code>geosapi::GSManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect"><a href='../../geosapi/html/GSManager.html#method-GSManager-connect'><code>geosapi::GSManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName"><a href='../../geosapi/html/GSManager.html#method-GSManager-getClassName'><code>geosapi::GSManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getCoverageStoreManager'><code>geosapi::GSManager$getCoverageStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getDataStoreManager'><code>geosapi::GSManager$getDataStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getNamespaceManager'><code>geosapi::GSManager$getNamespaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getServiceManager'><code>geosapi::GSManager$getServiceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getStyleManager'><code>geosapi::GSManager$getStyleManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus"><a href='../../geosapi/html/GSManager.html#method-GSManager-getSystemStatus'><code>geosapi::GSManager$getSystemStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl"><a href='../../geosapi/html/GSManager.html#method-GSManager-getUrl'><code>geosapi::GSManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getWorkspaceManager'><code>geosapi::GSManager$getWorkspaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize"><a href='../../geosapi/html/GSManager.html#method-GSManager-initialize'><code>geosapi::GSManager$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger"><a href='../../geosapi/html/GSManager.html#method-GSManager-logger'><code>geosapi::GSManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor"><a href='../../geosapi/html/GSManager.html#method-GSManager-monitor'><code>geosapi::GSManager$monitor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload"><a href='../../geosapi/html/GSManager.html#method-GSManager-reload'><code>geosapi::GSManager$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-getStyles"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-getStyles}{}}}
\subsection{Method \code{getStyles()}}{
Get the list of available styles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$getStyles(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{an optional workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{list} containing items of class \code{\link{GSStyle}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-getStyleNames"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-getStyleNames}{}}}
\subsection{Method \code{getStyleNames()}}{
Get the list of available style names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$getStyleNames(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{an optional workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-getStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-getStyle}{}}}
\subsection{Method \code{getStyle()}}{
Get a \code{\link{GSStyle}} object given a style name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$getStyle(style, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style name}

\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of class \link{GSStyle}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-createStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-createStyle}{}}}
\subsection{Method \code{createStyle()}}{
Creates a GeoServer style given a name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$createStyle(file, sldBody = NULL, name, raw = FALSE, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file}

\item{\code{sldBody}}{SLD body}

\item{\code{name}}{name}

\item{\code{raw}}{raw}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the style has been successfully created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-updateStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-updateStyle}{}}}
\subsection{Method \code{updateStyle()}}{
Updates a GeoServer style given a name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$updateStyle(file, sldBody = NULL, name, raw = FALSE, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file}

\item{\code{sldBody}}{SLD body}

\item{\code{name}}{name}

\item{\code{raw}}{raw}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the style has been successfully updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-deleteStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-deleteStyle}{}}}
\subsection{Method \code{deleteStyle()}}{
Deletes a style given a name.
   By defaut, the option \code{recurse} is set to FALSE, ie datastore layers are not removed.
   To remove all coverage store layers, set this option to TRUE. The \code{purge} parameter is used 
   to customize the delete of files on disk (in case the underlying reader implements a delete method).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$deleteStyle(name, recurse = FALSE, purge = FALSE, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}

\item{\code{recurse}}{recurse}

\item{\code{purge}}{purge}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the style has been successfully deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-getSLDVersion"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-getSLDVersion}{}}}
\subsection{Method \code{getSLDVersion()}}{
Get SLD version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$getSLDVersion(sldBody)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sldBody}}{SLD body}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-getSLDBody"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-getSLDBody}{}}}
\subsection{Method \code{getSLDBody()}}{
Get SLD body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$getSLDBody(style, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style name}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{xml_node-class}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyleManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyleManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyleManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
