% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_move_point.R
\name{geo_move_point}
\alias{geo_move_point}
\title{New Latitude and Longitude Points from Point, Bearing and Distance}
\usage{
geo_move_point(coordinates, bearing, distance)
}
\arguments{
\item{coordinates}{A vector contaning one latitude and longitude point}

\item{bearing}{The angle relative to north to move towards}

\item{distance}{The distance in kilometers to move away from the origin point}
}
\value{
Returns a vector of length 2 containing a latitude and longitude point.
}
\description{
Creates a new latitude, longitude point based on an origin point, bearing and distance
}
\examples{

# Load required packages
require(mapview)
require(sp)

# Create sample geo dataset
sample_coord <-
   matrix(
        c(
            sample(327131680:419648450, 1) / 10000000,
            sample(-1147301410:-1241938690, 1) / 10000000
        ),
        ncol = 2
    )

# Create new point
(gmp <- geo_move_point(sample_coord, sample(0:359, 1), 500))

# Join all the points into a single matrix
bound_poly <- rbind(sample_coord, gmp)

# Create SpacialPoints object and pass to mapview for visualization
mapview(
    SpatialPoints(
        bound_poly[,c(2, 1)],
        proj4string = CRS("+proj=longlat +datum=WGS84")
    )
)


}
\seealso{
\code{\link{geo_sed}} \code{\link{geo_point_dist}}
}
\author{
Shant Sukljian
}
\keyword{circle}
\keyword{disk}
\keyword{enclosing}
\keyword{geo}
\keyword{latitude}
\keyword{longitude}
\keyword{sed}
\keyword{smallest}
