% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-operation-adjust.R, R/operation-adjust.R
\docType{class}
\name{adjust}
\alias{adjust}
\alias{adjust-class}
\title{Adjust layer params and aesthetics (Layer operation)}
\usage{
adjust(object, mapping = aes(), ...)
}
\arguments{
\item{object}{One of:
\itemize{
\item A \link{layer-like} object: applies this operation to the layer.
\item A missing argument: creates an \link{operation}
\item Anything else: creates an \link{operation}, passing \code{object} along to the
\code{mapping} argument
}}

\item{mapping}{An aesthetic created using \code{aes()}. Mappings provided here
will overwrite mappings in \code{\link[ggplot2:layer]{ggplot2::layer()}}s when this \link{operation} is applied to
them.}

\item{...}{\code{\link[ggplot2:layer]{ggplot2::layer()}} parameters, such as would be passed to a \code{geom_...()}
or \code{stat_...()} call. Params provided here will overwrite params in layers when
this \link{operation} is applied to them.}
}
\value{
A \link{layer-like} object (if \code{object} is \link{layer-like}) or an \link{operation} (if not).
}
\description{
A layer \link{operation} for adjusting the params and aesthetic mappings of
a \link{layer-like} object.
}
\examples{

library(ggplot2)

# Here we use adjust() with nop() ( + 1) to create a copy of
# the stat_smooth layer, putting a white outline around it.
set.seed(1234)
k = 1000
data.frame(
  x = seq(1, 10, length.out = k),
  y = rnorm(k, seq(1, 2, length.out = k) + c(0, 0.5)),
  g = c("a", "b")
) |>
  ggplot(aes(x, y, color = g)) +
  geom_point() +
  stat_smooth(method = lm, formula = y ~ x, linewidth = 1.5, se = FALSE) *
    (adjust(aes(group = g), color = "white", linewidth = 4) + 1) +
  scale_color_brewer(palette = "Dark2")

# (note this could also be done with copy_under())

}
\seealso{
\link{operation} for a description of layer operations.

Other layer operations: 
\code{\link{affine_transform}},
\code{\link{blend}},
\code{\link{copy}},
\code{\link{nop}},
\code{\link{partition}()}
}
\concept{layer operations}
