% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-secondary.R
\name{sec_axis}
\alias{sec_axis}
\alias{dup_axis}
\alias{derive}
\title{Specify a secondary axis}
\usage{
sec_axis(
  transform = NULL,
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  guide = waiver(),
  trans = deprecated()
)

dup_axis(
  transform = ~.,
  name = derive(),
  breaks = derive(),
  labels = derive(),
  guide = derive(),
  trans = deprecated()
)

derive()
}
\arguments{
\item{transform}{A formula or function of transformation}

\item{name}{The name of the secondary axis}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks as output
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels as output
}}

\item{guide}{A position guide that will be used to render
the axis on the plot. Usually this is \code{\link[=guide_axis]{guide_axis()}}.}

\item{trans}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
This function is used in conjunction with a position scale to create a
secondary axis, positioned opposite of the primary axis. All secondary
axes must be based on a one-to-one transformation of the primary axes.
}
\details{
\code{sec_axis()} is used to create the specifications for a secondary axis.
Except for the \code{trans} argument any of the arguments can be set to
\code{derive()} which would result in the secondary axis inheriting the
settings from the primary axis.

\code{dup_axis()} is provide as a shorthand for creating a secondary axis that
is a duplication of the primary axis, effectively mirroring the primary axis.

As of v3.1, date and datetime scales have limited secondary axis capabilities.
Unlike other continuous scales, secondary axis transformations for date and datetime scales
must respect their primary POSIX data structure.
This means they may only be transformed via addition or subtraction, e.g.
\code{~ . + hms::hms(days = 8)}, or
\code{~ . - 8*60*60}. Nonlinear transformations will return an error.
To produce a time-since-event secondary axis in this context, users
may consider adapting secondary axis labels.
}
\examples{
p <- ggplot(mtcars, aes(cyl, mpg)) +
  geom_point()

# Create a simple secondary axis
p + scale_y_continuous(sec.axis = sec_axis(~ . + 10))

# Inherit the name from the primary axis
p + scale_y_continuous("Miles/gallon", sec.axis = sec_axis(~ . + 10, name = derive()))

# Duplicate the primary axis
p + scale_y_continuous(sec.axis = dup_axis())

# You can pass in a formula as a shorthand
p + scale_y_continuous(sec.axis = ~ .^2)

# Secondary axes work for date and datetime scales too:
df <- data.frame(
  dx = seq(
    as.POSIXct("2012-02-29 12:00:00", tz = "UTC"),
    length.out = 10,
    by = "4 hour"
  ),
  price = seq(20, 200000, length.out = 10)
 )

# This may useful for labelling different time scales in the same plot
ggplot(df, aes(x = dx, y = price)) +
  geom_line() +
  scale_x_datetime(
    "Date",
    date_labels = "\%b \%d",
    date_breaks = "6 hour",
    sec.axis = dup_axis(
      name = "Time of Day",
      labels = scales::label_time("\%I \%p")
    )
  )

# or to transform axes for different timezones
ggplot(df, aes(x = dx, y = price)) +
  geom_line() +
  scale_x_datetime("
    GMT",
    date_labels = "\%b \%d \%I \%p",
    sec.axis = sec_axis(
      ~ . + 8 * 3600,
      name = "GMT+8",
      labels = scales::label_time("\%b \%d \%I \%p")
    )
  )

}
