% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-find-wls.R
\name{stat_find_wls}
\alias{stat_find_wls}
\title{Find wavelength for target quantity value.}
\usage{
stat_find_wls(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  target = "half.maximum",
  interpolate = TRUE,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  x.label.fmt = label.fmt,
  y.label.fmt = label.fmt,
  x.label.transform = function(x) {
     x
 },
  y.label.transform = function(x) {
     x
 },
  x.colour.transform = x.label.transform,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{interpolate}{logical Indicating whether the nearest wavelength value in
\code{x} should be returned or a value calculated by linear interpolation
between wavelength values stradling the target.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{label.fmt, x.label.fmt, y.label.fmt}{character  strings giving a format
definition for construction of character strings labels with function
\code{\link{sprintf}} from \code{x} and/or \code{y} values.}

\item{x.label.transform, y.label.transform, x.colour.transform}{function Applied
to \code{x} or \code{y} values when constructing the character labels or
computing matching colours.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A data frame with one row for each match to the target subset from
  the data or linearly interpolated between the two nearest values available.
  As spectra are not monotonic in the spectral quantity, this statistic can
  return more than one row in \code{data} per target value.
}
\description{
\code{stat_find_wls} finds at which x positions values equal to a target are
located. \strong{Axis flipping is currently not supported.}
}
\details{
For each row in the subset of \code{data} matching  \code{target}
  a colour definition is computed assuming that after transformation with
  \code{x.colour.transform()} the values in \code{x} are wavelengths
  expressed in nanometres. Labels are constructed from \code{x} and \code{y}
  values after applying to them \code{x.label.transform} and
  \code{y.label.transform}, respectively. In most cases the
  \code{x.label.transform} is used to back-transform the values in \code{data}
  to make them agree with those displayed on the axis guides.

  These stats use \code{geom_point} by default as it is a geometry likely to
  work well in almost any situation. The additional default aesthetic
  mappings set by these statistics allow their direct use with
  \code{geom_text}, \code{geom_label}, \code{geom_line}, \code{geom_rug},
  \code{geom_hline} and \code{geom_vline}. The format of the labels returned
  can be controlled by the user.
}
\note{
These stats work nicely together with geoms \code{geom_text_repel} and
  \code{geom_label_repel} from package \code{\link[ggrepel]{ggrepel}} to
  solve the problem of overlapping labels by displacing them. To discard
  overlapping labels use \code{check_overlap = TRUE} as argument to
  \code{geom_text}. By default the labels are character values suitable to be
  plotted as is, but with a suitable \code{label.fmt} labels suitable for
  parsing by the geoms (e.g. into expressions containing greek letters or
  super or subscripts) can be also easily obtained.
}
\section{Computed variables}{
 \describe{ \item{x}{x-value at or nearest to the
  match to the target as numeric} \item{y}{target value or y-value nearest to
  the target as numeric} \item{x.label}{x-value at or nearest to the match
  formatted as character} \item{y.label}{target value or y-value nearest to
  the target formatted as character} \item{wl.color}{color definition calculated
  by assuming that x-values are wavelengths expressed in nanometres.} }
}

\section{Default aesthetics}{
 Set by the statistic and available to geoms.
  \describe{ \item{label}{..x.label..} \item{xintercept}{..x..}
  \item{yintercept}{..y..} \item{fill}{..wl.color..} }
}

\section{Required aesthetics}{
 Required by the statistic and need to be set
  with \code{aes()}. \describe{ \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity} }
}

\examples{

# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(yellow_gel.spct) +
  geom_line() +
  stat_find_wls(target = c(0.25, 0.5, 0.75))

ggplot(yellow_gel.spct) +
  geom_line() +
  stat_find_wls(target = "half.maximum", geom = "point", colour = "red") +
  stat_find_wls(target = "half.maximum", geom = "text", colour = "red",
             hjust = 1.1, label.fmt = "\%3.0f nm")
}
\seealso{
\code{\link[photobiology]{find_peaks}}.

Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_peaks}()},
\code{\link{stat_spikes}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
