% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_distance.R
\name{google_distance}
\alias{google_distance}
\title{Google Distance}
\usage{
google_distance(
  origins,
  destinations,
  mode = c("driving", "walking", "bicycling", "transit"),
  departure_time = NULL,
  arrival_time = NULL,
  avoid = NULL,
  units = c("metric", "imperial"),
  traffic_model = NULL,
  transit_mode = NULL,
  transit_routing_preference = NULL,
  language = NULL,
  key = get_api_key("distance"),
  simplify = TRUE,
  curl_proxy = NULL
)
}
\arguments{
\item{origins}{Origin locations as either a one or two column data.frame, a
list of unnamed elements, each element is either a numeric vector of lat/lon
coordinates, an address string or a place_id, or a vector of a pair of lat / lon coordinates}

\item{destinations}{destination locations as either a one or two column data.frame, a
list of unnamed elements, each element is either a numeric vector of lat/lon
coordinates, an address string or place_id, or a vector of a pair of lat / lon coordinates}

\item{mode}{\code{string} One of 'driving', 'walking', 'bicycling' or 'transit'.}

\item{departure_time}{The desired time of departure.
Use either a \code{POSIXct} time since 1st January 1970, or the string 'now'.
If no value is specified it defaults to \code{Sys.time()}.}

\item{arrival_time}{Specifies the desired time of arrival for transit requests.
Use either a \code{POSIXct} time since 1st January 1970.
Note you can only specify one of \code{arrival_time} or \code{departure_time}, not both.
If both are supplied, \code{departure_time} will be used.}

\item{avoid}{\code{character} vector stating which features should be avoided.
One of 'tolls', 'highways', 'ferries' or 'indoor'}

\item{units}{\code{string} metric or imperial. Note: Only affects the text displayed
within the distance field. The values are always in metric}

\item{traffic_model}{\code{string} - one of 'best_guess', 'pessimistic' or 'optimistic'.
Only valid with a departure time}

\item{transit_mode}{\code{vector} of strings, either 'bus', 'subway', 'train', 'tram' or 'rail'.
Only vaid where \code{mode = 'transit'}. Note that 'rail' is equivalent
to \code{transit_mode=c("train", "tram", "subway")}}

\item{transit_routing_preference}{\code{vector} strings - one of 'less_walking' and
'fewer_transfers'. specifies preferences for transit routes. Only valid for
transit directions.}

\item{language}{\code{string} - specifies the language in which to return the results.
See the list of supported languages: \url{https://developers.google.com/maps/faq#languagesupport}.
If no langauge is supplied, the service will attempt to use the language of the domain from which the request was sent}

\item{key}{\code{string} - a valid Google Developers Directions API key}

\item{simplify}{\code{logical} - TRUE indicates the returned JSON will be coerced into a list.
FALSE indicates the returend JSON will be returned as a string}

\item{curl_proxy}{a curl proxy object}
}
\value{
Either list or JSON string of the distance between origins and destinations
}
\description{
The Google Maps Distance Matrix API is a service that provides travel distance
and time for a matrix of origins and destinations, based on the recommended
route between start and end points.
}
\section{API use and limits}{


The amount of queries you can make to Google's APIs is dependent on both the service
and the API you are using.

Each API has specific quotas and limits. Check Google's API documentation for details.

View your usage at the Google Cloud Console \url{https://console.cloud.google.com/}

Each API can only accept and return one request at a time. If you write a loop
to make multiple API calls you should ensure you don't go over your quota / limits
during the loop.
}

\examples{
\dontrun{

set_key("YOUR_GOOGLE_API_KEY")
google_distance(origins = list(c("Melbourne Airport, Australia"),
                             c("MCG, Melbourne, Australia"),
                             c(-37.81659, 144.9841)),
                             destinations = c("Portsea, Melbourne, Australia"),
                             simplify = FALSE)

google_distance(origins = c(-37.816, 144.9841),
    destinations = c("Melbourne Airport, Australia", "Flinders Street Station, Melbourne"))

google_distance(origins = tram_stops[1:5, c("stop_lat", "stop_lon")],
     destinations = tram_stops[10:12, c("stop_lat", "stop_lon")],)

}
}
