% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_urls.R
\name{google_map_panorama}
\alias{google_map_panorama}
\title{Google Map Panorama}
\usage{
google_map_panorama(
  viewpoint = NULL,
  pano = NULL,
  heading = NULL,
  pitch = 0,
  fov = 90
)
}
\arguments{
\item{viewpoint}{vector of lat/lon coordinates. If NULL, \code{pano} must be used.}

\item{pano}{string of a specific panorama ID (see \url{https://developers.google.com/maps/documentation/urls/get-started#pano-id}).
If NULL, \code{viewpoint} must be used.}

\item{heading}{number between -180 and 360. Indicates the compass heading of the camera
in degrees clockwise from north.}

\item{pitch}{number between -90 and 90, specifying the angle, up or down, of the camera}

\item{fov}{number between 10 and 100, determines the orizontal field of view
of the image.}
}
\description{
Opens an interactive street view panorama in a browser
}
\examples{
\dontrun{

google_map_panorama(viewpoint = c(48.857832, 2.295226))

google_map_panorama(viewpoint = c(48.857832,2.295226),
  heading = -90, pitch = 38, fov = 80)

google_map_panorama(pano = "4U-oRQCNsC6u7r8gp02sLA")


}
}
