% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_glcm}
\alias{normalize_glcm}
\title{Normalize a GLCM}
\usage{
normalize_glcm(mat)
}
\arguments{
\item{mat}{gray-level co-occurrence matrix}
}
\value{
numeric matrix (same dimensions as input GLCM)
}
\description{
Function that normalizes a gray-level co-occurrence matrix (GLCM) so that the
sum of all the elements equals unity. This has the added benefit of
converting the GLCM to a probability distribution.
}
\examples{
# normalize an arbitrary matrix
a <- matrix(1:9, nrow = 3)
n_a <- normalize_glcm(a)

print(a)
print(n_a)
}
