% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.partialPlot}
\alias{h2o.partialPlot}
\title{Partial Dependence Plots}
\usage{
h2o.partialPlot(object, data, cols, destination_key, nbins = 20,
  plot = TRUE, plot_stddev = TRUE, weight_column = -1,
  include_na = FALSE, user_splits = NULL, save_to = NULL)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{data}{An H2OFrame object used for scoring and constructing the plot.}

\item{cols}{Feature(s) for which partial dependence will be calculated.}

\item{destination_key}{An key reference to the created partial dependence tables in H2O.}

\item{nbins}{Number of bins used. For categorical columns make sure the number of bins exceeds the level count.
If you enable add_missing_NA, the returned length will be nbin+1.}

\item{plot}{A logical specifying whether to plot partial dependence table.}

\item{plot_stddev}{A logical specifying whether to add std err to partial dependence plot.}

\item{weight_column}{A string denoting which column of data should be used as the weight column.}

\item{include_na}{A logical specifying whether missing value should be included in the Feature values.}

\item{user_splits}{A two-level nested list containing user defined split points for pdp plots for each column.
If there are two columns using user defined split points, there should be two lists in the nested list.
Inside each list, the first element is the column name followed by values defined by the user.}

\item{save_to}{Fully qualified prefix of the image files the resulting plots should be saved to, e.g. '/home/user/pdp'.
Plots for each feature are saved separately in PNG format, each file receives a suffix equal to the corresponding feature name, e.g. `/home/user/pdp_AGE.png`.
If the files already exists, they will be overridden. Files are only saves if plot = TRUE (default).}
}
\value{
Plot and list of calculated mean response tables for each feature requested.
}
\description{
Partial dependence plot gives a graphical depiction of the marginal effect of a variable on the response. The effect
of a variable is measured in change in the mean response. Note: Unlike randomForest's partialPlot when plotting
partial dependence the mean response (probabilities) is returned rather than the mean of the log class probability.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate[, "CAPSULE"] <- as.factor(prostate[, "CAPSULE"] )
prostate[, "RACE"] <- as.factor(prostate[,"RACE"] )
prostate_gbm <- h2o.gbm(x = c("AGE","RACE"),
                        y = "CAPSULE",
                        training_frame = prostate,
                        ntrees = 10,
                        max_depth = 5,
                        learn_rate = 0.1)
h2o.partialPlot(object = prostate_gbm, data = prostate, cols = c("AGE", "RACE"))
}
}
