// (c) The HDF Group
#ifndef H5FAprivate_H
#define H5FAprivate_H
#include "H5ACprivate.h"
#include "H5Fprivate.h"
typedef enum H5FA_cls_id_t {
    H5FA_CLS_CHUNK_ID = 0,
    H5FA_CLS_FILT_CHUNK_ID,
    H5FA_CLS_TEST_ID,
    H5FA_NUM_CLS_ID
} H5FA_cls_id_t;
typedef struct H5FA_class_t {
    H5FA_cls_id_t id;
    const char   *name;
    size_t        nat_elmt_size;
    void *(*crt_context)(void *udata);
    herr_t (*dst_context)(void *ctx);
    herr_t (*fill)(void  *nat_blk,
                   size_t nelmts);
    herr_t (*encode)(void *raw, const void *elmt, size_t nelmts,
                     void *ctx);
    herr_t (*decode)(const void *raw, void *elmt, size_t nelmts,
                     void *ctx);
    herr_t (*debug)(FILE *stream, int indent, int fwidth, hsize_t idx,
                    const void *elmt);
    void *(*crt_dbg_ctx)(H5F_t *f, haddr_t obj_addr);
    herr_t (*dst_dbg_ctx)(void *dbg_ctx);
} H5FA_class_t;
typedef struct H5FA_create_t {
    const H5FA_class_t *cls;
    uint8_t             raw_elmt_size;
    uint8_t             max_dblk_page_nelmts_bits;
    hsize_t nelmts;
} H5FA_create_t;
typedef struct H5FA_stat_t {
    hsize_t hdr_size;
    hsize_t dblk_size;
    hsize_t nelmts;
} H5FA_stat_t;
typedef struct H5FA_t H5FA_t;
typedef int (*H5FA_operator_t)(hsize_t idx, const void *_elmt, void *_udata);
H5_DLLVAR const H5FA_class_t H5FA_CLS_CHUNK[1];
H5_DLLVAR const H5FA_class_t H5FA_CLS_FILT_CHUNK[1];
H5_DLL H5FA_t *H5FA_create(H5F_t *f, const H5FA_create_t *cparam, void *ctx_udata);
H5_DLL H5FA_t *H5FA_open(H5F_t *f, haddr_t fa_addr, void *ctx_udata);
H5_DLL herr_t  H5FA_get_nelmts(const H5FA_t *fa, hsize_t *nelmts);
H5_DLL herr_t  H5FA_get_addr(const H5FA_t *fa, haddr_t *addr);
H5_DLL herr_t  H5FA_set(const H5FA_t *fa, hsize_t idx, const void *elmt);
H5_DLL herr_t  H5FA_get(const H5FA_t *fa, hsize_t idx, void *elmt);
H5_DLL herr_t  H5FA_depend(H5FA_t *fa, H5AC_proxy_entry_t *parent);
H5_DLL herr_t  H5FA_iterate(H5FA_t *fa, H5FA_operator_t op, void *udata);
H5_DLL herr_t  H5FA_close(H5FA_t *fa);
H5_DLL herr_t  H5FA_delete(H5F_t *f, haddr_t fa_addr, void *ctx_udata);
H5_DLL herr_t  H5FA_patch_file(H5FA_t *fa, H5F_t *f);
H5_DLL herr_t H5FA_get_stats(const H5FA_t *ea, H5FA_stat_t *stats);
#ifdef H5FA_DEBUG
#endif
#endif
