// (c) The HDF Group
#ifndef H5Tdevelop_H
#define H5Tdevelop_H
#include "H5Tpublic.h"
typedef enum H5T_cmd_t {
    H5T_CONV_INIT = 0,
    H5T_CONV_CONV = 1,
    H5T_CONV_FREE = 2
} H5T_cmd_t;
typedef enum H5T_bkg_t {
    H5T_BKG_NO   = 0,
    H5T_BKG_TEMP = 1,
    H5T_BKG_YES  = 2
} H5T_bkg_t;
//! <!-- [H5T_cdata_t_snip] -->
typedef struct H5T_cdata_t {
    H5T_cmd_t command;
    H5T_bkg_t need_bkg;
    hbool_t   recalc;
    void     *priv;
} H5T_cdata_t;
//! <!-- [H5T_cdata_t_snip] -->
typedef enum H5T_pers_t {
    H5T_PERS_DONTCARE = -1,
    H5T_PERS_HARD     = 0,
    H5T_PERS_SOFT     = 1
} H5T_pers_t;
//! <!-- [H5T_conv_t_snip] -->
typedef herr_t (*H5T_conv_t)(hid_t src_id, hid_t dst_id, H5T_cdata_t *cdata, size_t nelmts, size_t buf_stride,
                             size_t bkg_stride, void *buf, void *bkg, hid_t dset_xfer_plist);
//! <!-- [H5T_conv_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5Tregister(H5T_pers_t pers, const char *name, hid_t src_id, hid_t dst_id, H5T_conv_t func);
H5_DLL herr_t H5Tunregister(H5T_pers_t pers, const char *name, hid_t src_id, hid_t dst_id, H5T_conv_t func);
H5_DLL H5T_conv_t H5Tfind(hid_t src_id, hid_t dst_id, H5T_cdata_t **pcdata);
H5_DLL htri_t H5Tcompiler_conv(hid_t src_id, hid_t dst_id);
#ifdef __cplusplus
}
#endif
#ifndef H5_NO_DEPRECATED_SYMBOLS
#endif
#endif
