% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-hdnom-models.R
\name{hdcox.lasso}
\alias{hdcox.lasso}
\title{Lasso Model Selection for High-Dimensional Cox Models}
\usage{
hdcox.lasso(x, y, nfolds = 5L, rule = c("lambda.min", "lambda.1se"),
  seed = 1001)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response matrix made by \code{\link[survival]{Surv}}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{rule}{Model selection criterion, \code{"lambda.min"} or
\code{"lambda.1se"}. See \code{\link[glmnet]{cv.glmnet}}
for details.}

\item{seed}{A random seed for cross-validation fold division.}
}
\description{
Automatic lasso model selection for high-dimensional
Cox models, evaluated by penalized partial-likelihood.
}
\examples{
library("survival")
library("rms")

# Load imputed SMART data
data("smart")
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
y = Surv(time, event)

# Fit Cox model with lasso penalty
fit = hdcox.lasso(x, y, nfolds = 5, rule = "lambda.1se", seed = 11)

# Prepare data for hdnom.nomogram
x.df = as.data.frame(x)
dd = datadist(x.df)
options(datadist = "dd")

# Generate hdnom.nomogram objects and plot nomogram
nom = hdnom.nomogram(
  fit$lasso_model, model.type = "lasso",
  x, time, event, x.df, pred.at = 365 * 2,
  funlabel = "2-Year Overall Survival Probability")

plot(nom)
}
