% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.hdsvm.R
\name{nc.hdsvm}
\alias{nc.hdsvm}
\title{Solve the Penalized SVM with Nonconvex Penalties}
\usage{
nc.hdsvm(
  x,
  y,
  lambda,
  pen = "scad",
  aval = NULL,
  lam2 = 1,
  ini_beta = NULL,
  lla_step = 3,
  ...
)
}
\arguments{
\item{x}{Matrix of predictors, with dimensions (nobs * nvars); each row represents an observation.}

\item{y}{Response variable, with length \eqn{n}.}

\item{lambda}{Optional user-supplied sequence of \code{lambda} values. If unspecified, the program 
calculates its own sequence based on \code{nlambda} and \code{lambda.factor}. Supplying a decreasing 
sequence of \code{lambda} values is advisable to leverage the warm-start optimization.}

\item{pen}{Specifies the type of nonconvex penalty: "SCAD" or "MCP".}

\item{aval}{The parameter value for the SCAD or MCP penalty. Default is 3.7 for SCAD and 2 for MCP.}

\item{lam2}{Regularization parameter \code{lambda2} for the quadratic penalty on the coefficients. 
Only one value of \code{lambda2} is used per fit.}

\item{ini_beta}{Optional initial coefficients to start the fitting process.}

\item{lla_step}{Number of Local Linear Approximation (LLA) steps. Default is 3.}

\item{...}{Additional arguments passed to \code{\link{hdsvm}}.}
}
\value{
An object with S3 class \code{nc.hdsvm} consisting of
  \item{call}{the call that produced this object}
  \item{b0}{intercept sequence of length \code{length(lambda)}}
  \item{beta}{a \code{p*length(lambda)} matrix of coefficients,
              stored as a sparse matrix (\code{dgCMatrix} class,
              the standard class for sparse numeric matrices in
              the \code{Matrix} package.). To convert it into
              normal type matrix, use \code{as.matrix()}.}
  \item{lambda}{the actual sequence of \code{lambda} values used}
  \item{df}{the number of nonzero coefficients for each value
            of \code{lambda}.}
  \item{npasses}{the number of iterations for every lambda value}
  \item{jerr}{error flag, for warnings and errors, 0 if no error.}#'
}
\description{
This function fits the penalized SVM using nonconvex penalties 
such as SCAD or MCP. It allows for flexible control over the regularization parameters and 
offers advanced options for initializing and optimizing the fit.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x1 <- matrix(rnorm(n / 2 * p, -0.25, 0.1), n / 2)
x2 <- matrix(rnorm(n / 2 * p, 0.25, 0.1), n / 2)
x <- rbind(x1, x2)
beta <- 0.1 * rnorm(p)
prob <- plogis(c(x \%*\% beta))
y <- 2 * rbinom(n, 1, prob) - 1
lam2 <- 0.01
lambda <- 10^(seq(1,-4, length.out = 30)) 
\donttest{nc.fit <- nc.hdsvm(x = x, y = y, lambda = lambda, lam2 = lam2, pen = "scad")}
}
\keyword{classification}
\keyword{svm}
