% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hull_plot.R
\name{splitInTwo}
\alias{splitInTwo}
\title{Split the convex hull in two along an input line}
\usage{
splitInTwo(
  p,
  pointsDF,
  axisIntersect,
  pointCoords,
  borderPoints,
  legendLabs = paste0("Group ", seq(2)),
  alpha = 0.5
)
}
\arguments{
\item{p}{A ggplot object representing the hull.}

\item{pointsDF}{A data frame with the x and y coordinates of the points.}

\item{axisIntersect}{The coordinate where the vertical or horizontal line
intersects the relevant axis.}

\item{pointCoords}{The coordinates of the input points on the axis
perpendicular to the input border line.}

\item{borderPoints}{The points where the border line intersects the
convex hull.}

\item{legendLabs}{Legend labels.}

\item{alpha}{Opaqueness level.}
}
\value{
A ggplot object showing the hull split in two parts along the input
line.
}
\description{
This function splits the convex hull in two along an input vertical or
horizontal line.
}
\keyword{internal}
