% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_viz.R
\name{plot_carbontemp}
\alias{plot_carbontemp}
\title{Download and plot essential climate data}
\usage{
plot_carbontemp(dataset = merge_carbontemp(), print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{merge_carbontemp}}

\item{print}{(boolean) Display temperature anomaly ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with temperature anomaly vs carbon chart
}
\description{
Plots the global monthly mean temperature anomaly vs atmospheric carbon  with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_carbontemp} invisibly returns a ggplot2 object with a pre-defined temperature anomaly vs carbon chart using data from \code{merge_carbontemp}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch temperature anomaly:
mergedtemp <- merge_carbontemp()
#
# Plot output using package's built-in ggplot2 defaults
plot_carbontemp(mergedtemp)

# Or just call plot_carbontemp(), which defaults to merge_carbontemp() dataset
plot_carbontemp()

p <- plot_carbontemp(mergedtemp, print = FALSE)
# Modify plot such as: p + ggplot2::labs(title='The Signature of Climate Change') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
