% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_pbtk_sbml.R
\name{export_pbtk_sbml}
\alias{export_pbtk_sbml}
\title{Export model to sbml.}
\usage{
export_pbtk_sbml(
  initial.amounts = list(Agutlumen = 0),
  filename = "default.xml",
  folder = tempdir(),
  digits = 4,
  ...
)
}
\arguments{
\item{initial.amounts}{Must specify initial amounts in units of choice.}

\item{filename}{The name of the jarnac file containing the model.}

\item{folder}{The folder on the file system containing the output file. Defaults to \code{\link{tempdir}}.}

\item{digits}{Desired number of decimal places to round the parameters.}

\item{...}{Arguments to \code{\link{parameterize_pbtk}} such as chem.name, chem.cas, dtxsid, species.}
}
\value{
Text describing the PBTK model in SBML.
}
\description{
This function exports the multiple compartment PBTK model to an sbml file.
}
\details{
Compartments to enter into the initial.amounts list includes Agutlumen,
Aart, Aven, Alung, Agut, Aliver, Akidney, and Arest.

Parameters are generated by a call to \code{\link{parameterize_pbtk}}.
When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
}
\examples{

\donttest{
export_pbtk_sbml(chem.name='Nicotine',initial.amounts=list(Agutlumen=1),filename='PBTKmodel.xml')
}

}
\author{
Robert Pearce
}
\keyword{Export}
