% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.spe.R
\name{.read.spe.xml}
\alias{.read.spe.xml}
\title{Read XML footer from SPE file format version 3.0}
\usage{
.read.spe.xml(filename)
}
\arguments{
\item{filename}{- SPE filename}
}
\value{
xml data from the file converted to R list
}
\description{
The new SPE file format, introduced in 2012, was designed to be backwards compatible with the
previous format 2.5. The most prominent change is the new plain text XML footer holding vast
experimental metadata that gets attached at the end of the file. Thus, the file contains 3
blocks: a 4100-bytes long binary header, a chunk with spectral data, and the XML footer.
This function retrieves the XML footer converted to R list, and throws error if it is not available.
The file format specification is available at Princeton Instruments FTP server under name
'SPE 3.0 File Format Specification'.
}
\details{
This function relies on R package xml2 to work correctly
}
