% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupICA.R
\name{GroupICA}
\alias{GroupICA}
\title{Group Independent Component Analysis (GroupICA)}
\usage{
GroupICA(
  Xs,
  J1,
  J2 = J1,
  algorithm = c("pooled", "Calhoun2009", "Pfister2018"),
  ica.algorithm = c("FastICA", "InfoMax", "ExtInfoMax", "JADE", "AuxICA1", "AuxICA2",
    "IPCA", "SIMBEC", "AMUSE", "SOBI", "FOBI", "ProDenICA", "RICA"),
  num.iter = 30,
  thr = 1e-10,
  verbose = FALSE
)
}
\arguments{
\item{Xs}{A list containing multiple matrices}

\item{J1}{Rank parameter to decompose}

\item{J2}{Rank parameter used in Calhoun2009}

\item{algorithm}{Pool algorithm to merge multiple ICA results (Default: pooled)}

\item{ica.algorithm}{The decomposition algorithm (Default: "FastICA")}

\item{num.iter}{The number of iterations}

\item{thr}{The threshold to terminate the iteration (Default: 1E-10)}

\item{verbose}{Verbose option}
}
\value{
A list containing the result of the decomposition
}
\description{
The input data is assumed to be a list containing multiple matrices, which share common column.
}
\examples{
X1 <- matrix(runif(100*200), nrow=100, ncol=200)
X2 <- matrix(runif(150*200), nrow=150, ncol=200)
Xs <- list(X1=X1, X2=X2)
out <- GroupICA(Xs, J1=5)
}
