% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iglm.r
\docType{class}
\name{iglm_object_generator}
\alias{iglm_object_generator}
\title{An R6 class for Network GLM (Generalized Linear Model) Objects}
\description{
The `iglm_object` class encapsulates all components required to define,
estimate, and simulate from a network generalized linear model. This includes
the model formula, coefficients, the underlying network and attribute data
(via a `iglm.data` object), sampler controls, estimation controls, and storage
for results.
}
\references{
Fritz, C., Schweinberger, M. , Bhadra S., and D. R. Hunter (2025). A Regression Framework for Studying Relationships among Attributes under Network Interference. Journal of the American Statistical Association, to appear.

Stewart, J. R. and M. Schweinberger (2025). Pseudo-Likelihood-Based M-Estimation of Random Graphs with Dependent Edges and Parameter Vectors of Increasing Dimension. Annals of Statistics, to appear. 

Schweinberger, M. and M. S. Handcock (2015). Local dependence in random graph models: characterization, properties, and statistical inference. Journal of the Royal Statistical Society, Series B (Statistical Methodology), 7, 647-676.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{formula}}{(`formula`) Read-only. The model formula specifying terms and data object.}

\item{\code{coef}}{(`numeric`) Read-only. The current vector of non-popularity coefficient estimates or initial values.}

\item{\code{coef_popularity}}{(`numeric` or `NULL`) Read-only. The current vector of popularity coefficient estimates or initial values, or `NULL` if not applicable.}

\item{\code{results}}{(`results`) Read-only. The \code{\link{results}} R6 object containing all estimation and simulation outputs.}

\item{\code{iglm.data}}{(`iglm.data`) Read-only. The associated \code{\link{iglm.data}} R6 object containing the network and attribute data.}

\item{\code{control}}{(`control.iglm`) Read-only. The \code{\link{control.iglm}} object specifying estimation parameters.}

\item{\code{sampler}}{(`sampler_iglm`) Read-only. The  \code{\link{sampler_iglm}} object specifying MCMC sampling parameters.}

\item{\code{sufficient_statistics}}{(`numeric`) Read-only. A named vector of the observed network statistics corresponding to the model terms, calculated on the current `iglm.data` data.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-iglm_object-new}{\code{iglm_object_generator$new()}}
\item \href{#method-iglm_object-model_assessment}{\code{iglm_object_generator$model_assessment()}}
\item \href{#method-iglm_object-print}{\code{iglm_object_generator$print()}}
\item \href{#method-iglm_object-plot}{\code{iglm_object_generator$plot()}}
\item \href{#method-iglm_object-gather}{\code{iglm_object_generator$gather()}}
\item \href{#method-iglm_object-save}{\code{iglm_object_generator$save()}}
\item \href{#method-iglm_object-estimate}{\code{iglm_object_generator$estimate()}}
\item \href{#method-iglm_object-summary}{\code{iglm_object_generator$summary()}}
\item \href{#method-iglm_object-simulate}{\code{iglm_object_generator$simulate()}}
\item \href{#method-iglm_object-get_samples}{\code{iglm_object_generator$get_samples()}}
\item \href{#method-iglm_object-set_sampler}{\code{iglm_object_generator$set_sampler()}}
\item \href{#method-iglm_object-set_target}{\code{iglm_object_generator$set_target()}}
\item \href{#method-iglm_object-clone}{\code{iglm_object_generator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-new"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-new}{}}}
\subsection{Method \code{new()}}{
Internal method to calculate the observed count statistics based on the
model formula and the data in the `iglm.data` object. Populates the
`private$.sufficient_statistics` field.


Internal validation method. Checks the consistency and validity of
all components of the `iglm_object`. Stops with an error if any
check fails.


Creates a new `iglm_object`. This involves parsing the formula,
linking the data object, initializing coefficients, setting up sampler
and control objects, calculating initial statistics, and validating.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$new(
  formula = NULL,
  coef = NULL,
  coef_popularity = NULL,
  sampler = NULL,
  control = NULL,
  file = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{A model `formula` object. The left-hand side should be the
name of a \code{\link{iglm.data}} object available in the calling environment. 
See \code{\link{model_terms}} for details on specifying the right-hand side terms.}

\item{\code{coef}}{A numeric vector of initial coefficients for the terms in
the formula (excluding popularity). If `NULL`, coefficients are
initialized to zero.}

\item{\code{coef_popularity}}{An optional numeric vector of initial popularity
coefficients. Should be `NULL` if the formula does
not include popularity terms.}

\item{\code{sampler}}{A \code{\link{sampler_iglm}} object specifying the MCMC sampler
settings. If `NULL`, default settings are used.}

\item{\code{control}}{A \code{\link{control.iglm}} object specifying estimation control
parameters. If `NULL`, default settings are used.}

\item{\code{file}}{(character or `NULL`) If provided, loads the sampler state from
the specified .rds file instead of initializing from parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `iglm_object`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-model_assessment"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-model_assessment}{}}}
\subsection{Method \code{model_assessment()}}{
Performs model assessment by calculating specified network statistics
on the observed network and comparing their distribution to the
distribution obtained from simulated networks based on the current
model parameters. Requires simulations to have been run first (via
 \code{iglm_object$simulate} or \code{iglm_object_generator$estimate}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$model_assessment(formula)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{A formula specifying the network statistics to assess
(e.g., `~ degree_distribution() + geodesic_distances_distribution()`).
The terms should correspond to methods available in the \code{\link{iglm.data}} 
object that end with `distributions`. 
If the term mcmc_diagnostics is included, MCMC diagnostics will also be computed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class `iglm_model_assessment` containing the
  observed statistics and the distribution of simulated statistics.
  The result is also stored internally.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-print"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the `iglm_object`. If estimation results are
available, they are printed in a standard coefficient table format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$print(digits = 4, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{digits}}{(integer) Number of digits for rounding numeric output.}

\item{\code{...}}{Additional arguments (not used).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-plot"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the estimation results, including coefficient convergence
paths and model assessment diagnostics if available.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$plot(
  stats = FALSE,
  trace = FALSE,
  model_assessment = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stats}}{(logical) If `TRUE`, plot the observed vs. simulated
statistics from model assessment. Default is `FALSE`.}

\item{\code{trace}}{(logical) If `TRUE`, plot the coefficient convergence
paths. Default is `FALSE`.}

\item{\code{model_assessment}}{(logical) If `TRUE`, plot diagnostics from the
model assessment (if already carried out). Default is `FALSE`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-gather"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-gather}{}}}
\subsection{Method \code{gather()}}{
Gathers all components of the \code{\link{iglm_object}} into a single list for
easy saving or inspection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$gather()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing all key components of the \code{\link{iglm_object}}.
  This includes the formula, coefficients, sampler, control settings,
  preprocessing info, time taken for estimation, count statistics,
  results, and the underlying \code{\link{iglm.data}} data object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-save"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-save}{}}}
\subsection{Method \code{save()}}{
Save the \code{\link{iglm_object}} to a file in RDS format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$save(file = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(character) File path to save the object to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly returns `NULL`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-estimate"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-estimate}{}}}
\subsection{Method \code{estimate()}}{
Estimate the model parameters using the specified control settings.
Stores the results internally and updates the coefficient fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$estimate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
If the no preprocessing should be returned 
  (as per control settings), this function returns a list containing detailed estimation results, invisibly.
  Includes final coefficients, variance-covariance matrix, convergence
  path, Fisher information, score vector, log-likelihood, and any
  simulations performed during estimation.
  Else, the function returns a list of the desired preprocessed data (as a data.frame) and needed time.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-summary"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-summary}{}}}
\subsection{Method \code{summary()}}{
Provides a summary of the estimation results.
Requires the model to have been estimated first.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$summary(digits = 3)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{digits}}{(integer) Number of digits for rounding numeric output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Prints the summary to the console and returns `NULL` invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-simulate"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-simulate}{}}}
\subsection{Method \code{simulate()}}{
Simulate networks from the fitted model or a specified model. Stores
the simulations and/or summary statistics internally. The simulation 
is carried out using the internal MCMC sampler described in \code{\link{simulate_iglm}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$simulate(
  nsim = 1,
  only_stats = FALSE,
  display_progress = TRUE,
  offset_nonoverlap = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nsim}}{(integer) Number of networks to simulate. Default is 1.}

\item{\code{only_stats}}{(logical) If `TRUE`, only calculate and store summary
statistics for each simulation, discarding the network object itself.
Default is `FALSE`.}

\item{\code{display_progress}}{(logical) If `TRUE` (default), display a
progress bar during simulation.}

\item{\code{offset_nonoverlap}}{(numeric) Offset to apply for non-overlapping
dyads during simulation (if applicable to the sampler). This option 
is useful if the sparsity of edges of units with non-overlapping 
neighborhoods is known. Default is 0.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing the simulated networks (`samples`, as a
  `iglm.data.list` if `only_stats = FALSE`) and/or their summary
  statistics (`stats`), invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-get_samples"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-get_samples}{}}}
\subsection{Method \code{get_samples()}}{
Retrieve the simulated networks stored in the object.
Requires \code{simulate} or \code{estimate} to have been run first.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$get_samples()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{\link{iglm.data}} objects representing
  the simulated networks, invisibly. Returns an error if no samples
  are available.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-set_sampler"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-set_sampler}{}}}
\subsection{Method \code{set_sampler()}}{
Replace the internal MCMC sampler with a new one.
This is useful for changing the sampling scheme without
redefining the entire model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$set_sampler(sampler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sampler}}{A \code{\link{sampler_iglm}} object.
@return The \code{\link{iglm_object}} itself, invisibly.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-set_target"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-set_target}{}}}
\subsection{Method \code{set_target()}}{
Replace the internal `iglm.data` data object with a new one. This is
useful for applying a fitted model to new observed data. Recalculates
count statistics and re-validates the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$set_target(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A \code{\link{iglm.data}} `` object containing the new observed data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{iglm_object}} itself, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iglm_object-clone"></a>}}
\if{latex}{\out{\hypertarget{method-iglm_object-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{iglm_object_generator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
