% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{autoplot.importance_perm}
\alias{autoplot.importance_perm}
\title{Visualize importance scores}
\usage{
\method{autoplot}{importance_perm}(
  object,
  top = Inf,
  metric = NULL,
  eval_time = NULL,
  type = "importance",
  std_errs = stats::qnorm(0.95),
  ...
)
}
\arguments{
\item{object}{A tibble of results from \code{\link[=importance_perm]{importance_perm()}}.}

\item{top}{An integer for how many terms to show. To define importance when
there are multiple metrics, the rankings of predictors are computed across
metrics and the average rank is used. In the case of tied rankings, all the
ties are included.}

\item{metric}{A character vector or \code{NULL} for which metric to plot. By
default, all metrics will be shown via facets. Possible options are
the entries in \code{.metric} column of the object.}

\item{eval_time}{For censored regression models, a vector of time points at
which the survival probability is estimated.}

\item{type}{A character value. The default is \code{"importance"} which shows the
overall signal-to-noise ration (i.e., mean divided by standard error).
Alternatively, \code{"difference"} shows the mean difference value with standard
error bounds.}

\item{std_errs}{The number of standard errors to plot (when \code{type = "difference"}).}

\item{...}{Not used.}
}
\value{
A \code{ggplot2} object.
}
\description{
Visualize importance scores
}
\examples{
# Pre-computed results. See code at
system.file("make_imp_example.R", package = "important")

# Load the results
load(system.file("imp_examples.RData", package = "important"))

# A classification model with two classes and highly correlated predictors.
# To preprocess them, PCA feature extraction is used.
#
# Let’s first view the importance in terms of the original predictor set
# using 50 permutations:

imp_orig

autoplot(imp_orig, top = 10)

# Now assess the importance in terms of the PCA components

imp_derv

autoplot(imp_derv)
autoplot(imp_derv, metric = "brier_class", type = "difference")
}
