% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{malaria_mice_df}
\alias{malaria_mice_df}
\title{Daily Measures of Malaria-Infected Mice}
\format{
A data frame with 1300 observations and 11 variables:
\describe{
  \item{Line}{Integer vector indicating the parasite line}
  \item{Day}{Integer vector representing the day of observation}
  \item{Box}{Integer vector identifying the box where the mouse was housed}
  \item{Mouse}{Integer vector identifying the individual mouse}
  \item{Treatment}{Factor indicating the treatment group (6 levels)}
  \item{Ind2}{Integer vector used to identify individual measurements}
  \item{Weight}{Numeric vector indicating the weight of the mouse}
  \item{Glucose}{Integer vector indicating glucose levels}
  \item{RBC}{Numeric vector representing red blood cell counts}
  \item{Sample}{Integer vector identifying sample number}
  \item{Para}{Numeric vector indicating parasitemia levels}
}
}
\source{
Data taken from the epimdr package version 0.6-5
}
\usage{
data(malaria_mice_df)
}
\description{
This dataset, malaria_mice_df, is a data frame containing daily data on
laboratory mice infected with various strains of *Plasmodium chaubaudi*.
}
\details{
The dataset name has been kept as 'malaria_mice_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
