# Influx OSS API Service
#
# No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
#
# The version of the OpenAPI document: 2.0.0
#
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Query operations
#' @description influxdbclient.Query
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ GetQuerySuggestions } \emph{  }
#' 
#'
#' \itemize{
#' \item \emph{ @param } zap.trace.span character
#' \item \emph{ @returnType } \link{FluxSuggestions} \cr
#'
#'
#' \item status code : 200 | Suggestions for next functions in call chain
#'
#' \item return type : FluxSuggestions 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 0 | Any response other than 200 is an internal server error
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ GetQuerySuggestionsName } \emph{  }
#' 
#'
#' \itemize{
#' \item \emph{ @param } name character
#' \item \emph{ @param } zap.trace.span character
#' \item \emph{ @returnType } \link{FluxSuggestion} \cr
#'
#'
#' \item status code : 200 | Suggestions for next functions in call chain
#'
#' \item return type : FluxSuggestion 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 0 | Any response other than 200 is an internal server error
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ PostQuery } \emph{ Query InfluxDB }
#' 
#'
#' \itemize{
#' \item \emph{ @param } zap.trace.span character
#' \item \emph{ @param } accept.encoding Enum < [gzip, identity] > 
#' \item \emph{ @param } content.type Enum < [application/json, application/vnd.flux] > 
#' \item \emph{ @param } org character
#' \item \emph{ @param } org.id character
#' \item \emph{ @param } query \link{Query}
#'
#'
#' \item status code : 200 | Query results
#'
#' \item return type : character 
#' \item response headers :
#'
#' \tabular{ll}{
#' Content-Encoding \tab The Content-Encoding entity header is used to compress the media-type.  When present, its value indicates which encodings were applied to the entity-body \cr
#' Trace-Id \tab The Trace-Id header reports the request&#39;s trace ID, if one was generated. \cr
#' }
#' \item status code : 429 | Token is temporarily over quota. The Retry-After header describes when to try the read again.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' Retry-After \tab A non-negative decimal integer indicating the seconds to delay after the response is received. \cr
#' }
#' \item status code : 0 | Error processing query
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ PostQueryAnalyze } \emph{ Analyze an InfluxQL or Flux query }
#' 
#'
#' \itemize{
#' \item \emph{ @param } zap.trace.span character
#' \item \emph{ @param } content.type Enum < [application/json] > 
#' \item \emph{ @param } query \link{Query}
#' \item \emph{ @returnType } \link{AnalyzeQueryResponse} \cr
#'
#'
#' \item status code : 200 | Query analyze results. Errors will be empty if the query is valid.
#'
#' \item return type : AnalyzeQueryResponse 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 0 | Internal server error
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-Influx-Error \tab Error string describing the problem \cr
#' X-Influx-Reference \tab Reference code unique to the error type \cr
#' }
#' }
#'
#' \strong{ PostQueryAst } \emph{  }
#' Analyzes flux query and generates a query specification.
#'
#' \itemize{
#' \item \emph{ @param } zap.trace.span character
#' \item \emph{ @param } content.type Enum < [application/json] > 
#' \item \emph{ @param } language.request \link{LanguageRequest}
#' \item \emph{ @returnType } \link{ASTResponse} \cr
#'
#'
#' \item status code : 200 | Abstract syntax tree of flux query.
#'
#' \item return type : ASTResponse 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 0 | Any response other than 200 is an internal server error
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  GetQuerySuggestions  ####################
#'
#' library(influxdbclient)
#' var.zap.trace.span <- '{\"trace_id\":\"1\",\"span_id\":\"1\",\"baggage\":{\"key\":\"value\"}}' # character | OpenTracing span context
#'
#' api.instance <- QueryApi$new()
#'
#' result <- api.instance$GetQuerySuggestions(zap.trace.span=var.zap.trace.span)
#'
#'
#' ####################  GetQuerySuggestionsName  ####################
#'
#' library(influxdbclient)
#' var.name <- 'name_example' # character | The name of the branching suggestion.
#' var.zap.trace.span <- '{\"trace_id\":\"1\",\"span_id\":\"1\",\"baggage\":{\"key\":\"value\"}}' # character | OpenTracing span context
#'
#' api.instance <- QueryApi$new()
#'
#' result <- api.instance$GetQuerySuggestionsName(var.name, zap.trace.span=var.zap.trace.span)
#'
#'
#' ####################  PostQuery  ####################
#'
#' library(influxdbclient)
#' var.zap.trace.span <- '{\"trace_id\":\"1\",\"span_id\":\"1\",\"baggage\":{\"key\":\"value\"}}' # character | OpenTracing span context
#' var.accept.encoding <- 'identity' # character | The Accept-Encoding request HTTP header advertises which content encoding, usually a compression algorithm, the client is able to understand.
#' var.content.type <- 'content.type_example' # character | 
#' var.org <- 'org_example' # character | Specifies the name of the organization executing the query. Takes either the ID or Name interchangeably. If both `orgID` and `org` are specified, `org` takes precedence.
#' var.org.id <- 'org.id_example' # character | Specifies the ID of the organization executing the query. If both `orgID` and `org` are specified, `org` takes precedence.
#' var.query <- Query$new() # Query | Flux query or specification to execute
#'
#' #Query InfluxDB
#' api.instance <- QueryApi$new()
#'
#' result <- api.instance$PostQuery(zap.trace.span=var.zap.trace.span, accept.encoding=var.accept.encoding, content.type=var.content.type, org=var.org, org.id=var.org.id, query=var.query)
#'
#'
#' ####################  PostQueryAnalyze  ####################
#'
#' library(influxdbclient)
#' var.zap.trace.span <- '{\"trace_id\":\"1\",\"span_id\":\"1\",\"baggage\":{\"key\":\"value\"}}' # character | OpenTracing span context
#' var.content.type <- 'content.type_example' # character | 
#' var.query <- Query$new() # Query | Flux or InfluxQL query to analyze
#'
#' #Analyze an InfluxQL or Flux query
#' api.instance <- QueryApi$new()
#'
#' result <- api.instance$PostQueryAnalyze(zap.trace.span=var.zap.trace.span, content.type=var.content.type, query=var.query)
#'
#'
#' ####################  PostQueryAst  ####################
#'
#' library(influxdbclient)
#' var.zap.trace.span <- '{\"trace_id\":\"1\",\"span_id\":\"1\",\"baggage\":{\"key\":\"value\"}}' # character | OpenTracing span context
#' var.content.type <- 'content.type_example' # character | 
#' var.language.request <- LanguageRequest$new() # LanguageRequest | Analyzed Flux query to generate abstract syntax tree.
#'
#' api.instance <- QueryApi$new()
#'
#' result <- api.instance$PostQueryAst(zap.trace.span=var.zap.trace.span, content.type=var.content.type, language.request=var.language.request)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @export
QueryApi <- R6::R6Class(
  'QueryApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    GetQuerySuggestions = function(zap.trace.span=NULL, ...){
      apiResponse <- self$GetQuerySuggestionsWithHttpInfo(zap.trace.span, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetQuerySuggestionsWithHttpInfo = function(zap.trace.span=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (!is.null(`zap.trace.span`)) {
        headerParams['Zap-Trace-Span'] <- `zap.trace.span`
      }

      body <- NULL
      urlPath <- "/query/suggestions"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "FluxSuggestions", loadNamespace("influxdbclient")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    GetQuerySuggestionsName = function(name, zap.trace.span=NULL, ...){
      apiResponse <- self$GetQuerySuggestionsNameWithHttpInfo(name, zap.trace.span, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetQuerySuggestionsNameWithHttpInfo = function(name, zap.trace.span=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`name`)) {
        stop("Missing required parameter `name`.")
      }

      if (!is.null(`zap.trace.span`)) {
        headerParams['Zap-Trace-Span'] <- `zap.trace.span`
      }

      body <- NULL
      urlPath <- "/query/suggestions/{name}"
      if (!missing(`name`)) {
        urlPath <- gsub(paste0("\\{", "name", "\\}"), URLencode(as.character(`name`), reserved = TRUE), urlPath)
      }


      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "FluxSuggestion", loadNamespace("influxdbclient")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    PostQuery = function(zap.trace.span=NULL, accept.encoding='identity', content.type=NULL, org=NULL, org.id=NULL, query=NULL, ...){
      apiResponse <- self$PostQueryWithHttpInfo(zap.trace.span, accept.encoding, content.type, org, org.id, query, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    PostQueryWithHttpInfo = function(zap.trace.span=NULL, accept.encoding='identity', content.type=NULL, org=NULL, org.id=NULL, query=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (!is.null(`zap.trace.span`)) {
        headerParams['Zap-Trace-Span'] <- `zap.trace.span`
      }

      if (!is.null(`accept.encoding`)) {
        headerParams['Accept-Encoding'] <- `accept.encoding`
      }

      if (!is.null(`content.type`)) {
        headerParams['Content-Type'] <- `content.type`
      }

      if (!is.null(org)) {
        queryParams['org'] <- org
      }

      if (!is.null(org.id)) {
        queryParams['orgID'] <- org.id
      }

      if (!missing(`query`)) {
        contentType <- headerParams['Content-Type']
        if (is.na(contentType) || is.null(contentType) || startsWith(contentType, 'application/json')) {
          body <- `query`$toJSONString()
        }
      } else {
        body <- NULL
      }

      urlPath <- "/query"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "character", loadNamespace("influxdbclient")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    PostQueryAnalyze = function(zap.trace.span=NULL, content.type=NULL, query=NULL, ...){
      apiResponse <- self$PostQueryAnalyzeWithHttpInfo(zap.trace.span, content.type, query, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    PostQueryAnalyzeWithHttpInfo = function(zap.trace.span=NULL, content.type=NULL, query=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (!is.null(`zap.trace.span`)) {
        headerParams['Zap-Trace-Span'] <- `zap.trace.span`
      }

      if (!is.null(`content.type`)) {
        headerParams['Content-Type'] <- `content.type`
      }

      if (!missing(`query`)) {
        contentType <- headerParams['Content-Type']
        if (is.na(contentType) || is.null(contentType) || startsWith(contentType, 'application/json')) {
          body <- `query`$toJSONString()
        }
      } else {
        body <- NULL
      }

      urlPath <- "/query/analyze"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "AnalyzeQueryResponse", loadNamespace("influxdbclient")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    PostQueryAst = function(zap.trace.span=NULL, content.type=NULL, language.request=NULL, ...){
      apiResponse <- self$PostQueryAstWithHttpInfo(zap.trace.span, content.type, language.request, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    PostQueryAstWithHttpInfo = function(zap.trace.span=NULL, content.type=NULL, language.request=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (!is.null(`zap.trace.span`)) {
        headerParams['Zap-Trace-Span'] <- `zap.trace.span`
      }

      if (!is.null(`content.type`)) {
        headerParams['Content-Type'] <- `content.type`
      }

      if (!missing(`language.request`)) {
        contentType <- headerParams['Content-Type']
        if (is.na(contentType) || is.null(contentType) || startsWith(contentType, 'application/json')) {
          body <- `language.request`$toJSONString()
        }
      } else {
        body <- NULL
      }

      urlPath <- "/query/ast"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "ASTResponse", loadNamespace("influxdbclient")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    }
  )
)
