% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ivLT.R
\name{opC.r}
\alias{opC.ds_dphi}
\alias{opC.r}
\title{Optimum Contour}
\usage{
opC.r(phi, m = 1, t = 5)

opC.ds_dphi(phi, m = 1, t = 5)
}
\arguments{
\item{phi}{\eqn{\phi} value}

\item{m}{width of the contour - too small and get too close to singularities on negative \eqn{x}-axis, too large and encounter instability for large positive \eqn{x}}

\item{t}{standard (time) domain variable, also affects contour width}
}
\description{
The optimum contour with polar co-ordinates (\eqn{r} as a function of \eqn{\phi}) and complex length increment with \eqn{\phi} (Evans and Chung, 2000)
}
\details{
if \code{t} is set as zero, it is changed to 5 (avoids dividing by 0)

Evans & Chung, 2000: Laplace transform inversions using optimal contours in the complex plane \emph{International Journal of Computer Mathematics} v73 pp531-543.
}
\section{Functions}{
\itemize{
\item \code{opC.r}: \eqn{r}

\item \code{opC.ds_dphi}: \eqn{ds/d\phi}
}}

