% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_2comp.R
\name{auc_2comp}
\alias{auc_2comp}
\title{Analytical AUC for the 2-compartment model}
\usage{
auc_2comp(params, time, dose, route, medium = "plasma")
}
\arguments{
\item{params}{A named list of parameter values including the following:
\itemize{
\item k12: Rate at which compound moves from central to peripheral
compartment, 1/h.
\item k21: Rate at which compound moves from peripheral to central compartment, 1/h.
\item kelim: Elimination rate, 1/h.
\item V1: Apparent volume of central compartment, L/kg BW. Or see below for "Fgutabs_V1"
}

For oral administration (\code{route} FALSE), \code{params} must also include:
\itemize{
\item Fgutabs: Oral bioavailability, unitless fraction. Or see below for "Fgutabs_V1"
\item kgutabs: Rate of absorption from gut, 1/h.
}

For oral administration, in lieu of "V1" and "Fgutabs", you may instead
provide "Fgutabs_V1", the ratio of Fgutabs to V1 (1/L). This is an
alternate parameterization for situations where "Fgutabs" and "V1" are not
identifiable separately (i.e. when oral data are available, but IV data are
not). If "Fgutabs" and "V1" are provided, then "Fgutabs_V1" will not be
used.}

\item{time}{A numeric vector of time values, in hours}

\item{dose}{A numeric vector of doses in mg/kg}

\item{route}{A logical vector: TRUE for single IV bolus dose, FALSE for single oral dose}

\item{medium}{A character string that determines the measured media. Default: "plasma".}
}
\value{
A vector of plasma AUC values, evaluated at each time point in \code{time}.
}
\description{
Calculate area under the plasma concentration vs. time curve for the
1-compartment model, using an analytical equation (the integral of the
1-compartment model equation with respect to time).
}
\seealso{
Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{auc_flat}()},
\code{\link{cp_1comp}()},
\code{\link{cp_1comp_cl}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_1comp_fup}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other 2-compartment model functions: 
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{get_params_2comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other model AUC functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{auc_flat}()}
}
\author{
Caroline Ring, John Wambaugh
}
\concept{2-compartment model functions}
\concept{built-in model functions}
\concept{model AUC functions}
