% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{add_covariates}
\alias{add_covariates}
\title{Add fixed effects of one or several covariates to some parameters.}
\usage{
add_covariates(nm, ..., use_regexpr = TRUE)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{...}{One or several formulas defining the covariates.}

\item{use_regexpr}{Boolean, use regular expression to match the parameters
affected by the formulas?}
}
\value{
A \code{networkModel} object.
}
\description{
Note that new global parameters are not given any default prior.
}
\examples{
# Using a subset of the topology from the Trinidad case study
m <- new_networkModel() \%>\%
  set_topo("NH4, NO3 -> epi, FBOM", "epi -> petro, pseph")

# Taking initial condtions from the 'lalaja' dataset at t=0
# Grouping by transect id
inits <- lalaja[lalaja[["time.days"]] == 0, ]
inits
m <- set_init(m, inits, comp = "compartment", size = "mgN.per.m2",
              prop = "prop15N", group_by = "transect")
m

# Default model
params(m, simplify = TRUE)

# Adding an effect of the "transect" covariate on some parameters
m <- add_covariates(m, upsilon_epi_to_pseph ~ transect)
params(m, simplify = TRUE)

}
