% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_predictions.R
\name{tidy_flows}
\alias{tidy_flows}
\title{Build a tidy table with the flows for each iteration}
\usage{
tidy_flows(
  nm,
  mcmc,
  n_per_chain = NULL,
  n = NULL,
  n_grid = 64,
  steady_state = FALSE,
  dt = NULL,
  grid_size = NULL,
  at = NULL,
  end = NULL,
  use_cache = TRUE,
  cores = NULL
)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{mcmc}{The corresponding output from \code{run_mcmc}.}

\item{n_per_chain}{Integer, number of iterations randomly drawn per
chain. Note that iterations are in sync across chains (in practice, random
iterations are chosen, and then parameter values extracted for those same
iterations from all chains).}

\item{n}{Integer, number of iterations randomly drawn from \code{mcmc}. Note
that iterations are *not* drawn in sync across chains in this case (use
\code{n_per_chain} if you need to have the same iterations taken across all
chains).}

\item{n_grid}{Size of the time grid used to calculate trajectories}

\item{steady_state}{Boolean (default: FALSE). If TRUE, then steady state
compartment sizes are calculated for each iteration and steady state flows
are calculated from those compartment sizes. Note that any pulse that
might be specified in the input model \code{nm} is ignored in this case.}

\item{dt, grid_size}{Time step size or grid points, respectively.}

\item{at}{Timepoints at which the predictions should be returned.}

\item{end}{Final timepoint used in the projections.}

\item{use_cache}{Boolean, use cache for faster calculations?}

\item{cores}{Number of cores to use for parallel calculations. Default is
\code{NULL}, which means to use the value stored in
\code{options()[["mc.cores"]]} (or 1 if this value is not set).}
}
\value{
A tidy table containing the mcmc iterations (chain, iteration,
    parameters), the grouping variables from the network model and the
    flows. The returned flow values are the average flow per unit of time
    over the trajectory calculations (or steady state flows if
    \code{steady_state} is TRUE).
}
\description{
If neither \code{n_per_chain} and \code{n} are provided, all iterations are
used.
}
\details{
Warning: This function is still maturing and its interface and output might
change in the future.

Note about how steady state sizes for split compartments are calculated: the
steady size of the active portion is calculated divide it is divided by the
active fraction (portion.act parameter) to get the total size including the
refractory portion. In this case we get a "steady-state" refractory portion,
consistent with steady state size of active fraction and with portion.act
parameter.
}
\examples{
tf <- tidy_flows(aquarium_mod, aquarium_run, n_per_chain = 25, cores = 2)
tf
tfmcmc <- as.mcmc.list(tf)
plot(tfmcmc)

}
