% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPP.R
\name{ZonalQPol}
\alias{ZonalQPol}
\title{Quaternionic zonal polynomial - C++ implementation}
\usage{
ZonalQPol(n, lambda)
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}
}
\value{
A \code{qspray} multivariate polynomial.
}
\description{
Returns a quaternionic zonal polynomial. The quaternionic
  zonal polynomials are the Jack \eqn{C}-polynomials with Jack
  parameter \eqn{\alpha=1/Z}.
}
\examples{
( zonalQ <- ZonalQPol(3, lambda = c(3, 1)) )
zonalQ == JackPol(3, lambda = c(3, 1), alpha = "1/2", which = "C")
}
