% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtKostkaPolynomials.R
\name{qtSkewKostkaPolynomials}
\alias{qtSkewKostkaPolynomials}
\title{Skew qt-Kostka polynomials}
\usage{
qtSkewKostkaPolynomials(lambda, mu)
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}
}
\value{
A list. The skew qt-Kostka polynomials are usually denoted by
  \eqn{K_{\lambda/\mu, \nu}(q, t)} where \eqn{q} and \eqn{t} denote the two
  variables, \eqn{\lambda} and \eqn{\mu} are the two integer partitions
  defining the skew partition, and \eqn{\nu} is an integer partition.
  One obtains the skew Kostka-Foulkes polynomials by substituting \eqn{q}
  with \eqn{0}.
  For given partitions \eqn{\lambda} and \eqn{\mu}, the function returns the
  polynomials \eqn{K_{\lambda/\mu, \nu}(q, t)} as \code{qspray} objects
  for all partitions \eqn{\nu} of the same weight as the skew partition. The
  generated list is a list of lists with two elements: the integer
  partition \eqn{\nu} and the polynomial.
}
\description{
Skew qt-Kostka polynomials associated to a given skew
   partition.
}
