% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSchurPolynomial.R
\name{tSchurPol}
\alias{tSchurPol}
\title{t-Schur polynomial}
\usage{
tSchurPol(n, lambda)
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{integer partition}
}
\value{
A \code{symbolicQspray} multivariate polynomial, the
  t-Schur polynomial associated to \code{lambda}.
  It has a single parameter usually denoted by \eqn{t} and its
  coefficients are polynomials in this parameter. Substituting
  \eqn{t} with \eqn{0} yields the Schur polynomials.
}
\description{
Returns the t-Schur polynomial associated to
  the given partition.
}
\note{
The name "t-Schur polynomial" is taken from
  \href{https://www.sciencedirect.com/science/article/pii/S0097316518300724}{Wheeler and Zinn-Justin's paper}
  \emph{Hall polynomials, inverse Kostka polynomials and puzzles}.
}
