% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.hmr.R
\name{effect.hmr}
\alias{effect.hmr}
\title{Posterior distribution of Effectiveness for a subgroup of patients}
\usage{
\method{effect}{hmr}(
  object,
  B.lower = 0,
  B.upper = 3,
  k = 1,
  level = c(0.5, 0.75, 0.95),
  x.lim = c(-9, 5),
  y.lim = c(-1, 5),
  x.lab = "Baseline risk",
  y.lab = "Effectiveness",
  title.plot = paste("Posterior Effectiveness for a subgroup (50\%, 75\% and 95\%)"),
  kde2d.n = 25,
  marginals = TRUE,
  bin.hist = 30,
  color.line = "black",
  color.hist = "white",
  color.data.points = "black",
  alpha.data.points = 0.1,
  S = 5000,
  display.probability = FALSE,
  line.no.effect = 0,
  font.size.title = 20,
  ...
)
}
\arguments{
\item{object}{The object generated by the function hmr.}

\item{B.lower}{Lower limit of bias correction. The default is 0 meaning no bias correction.}

\item{B.upper}{Upper limit of bias correction. The default is 3 meaning three times bias correction.}

\item{k}{Covariable number indicating the subgroup.}

\item{level}{Vector with the probability levels of the contour plot. The default values are: 0.5, 0.75, and 0.95.}

\item{x.lim}{Numeric vector of length 2 specifying the x-axis limits.}

\item{y.lim}{Numeric vector of length 2 specifying the y-axis limits.}

\item{x.lab}{Text with the label of the x-axis.}

\item{y.lab}{Text with the label of the y-axis.}

\item{title.plot}{Text for setting a title in the bias plot.}

\item{kde2d.n}{The number of grid points in each direction for the non-parametric density estimation. The default is 25.}

\item{marginals}{If TRUE the marginal histograms of the posteriors are added to the plot.}

\item{bin.hist}{The number of bins in for the histograms. The default value is 30.}

\item{color.line}{The color of the contour lines. The default is "black.}

\item{color.hist}{The color of the histogram bars. The default is "white".}

\item{color.data.points}{The color of the data points. The default is "black".}

\item{alpha.data.points}{Transparency of the data points.}

\item{S}{The number of sample values from the joint posterior distribution used to approximate the contours. The default is S=5000.}

\item{display.probability}{Logical, if TRUE the figure display probabilities.}

\item{line.no.effect}{Horizontal line used as reference for no effect.}

\item{font.size.title}{Font size of the title.}

\item{...}{\dots}
}
\description{
This function estimates the posterior distribution for a subgroup of patients identified with the function hmr (Hierarchical Meta-Regression).
}
